% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LSD.intersphere.R
\name{intersphere}
\alias{LSD.intersphere}
\alias{intersphere}
\title{Intersphere: a fancy Venn diagram}
\usage{
intersphere(data, colors = NULL, alpha = 25, cex = 1,
  expand.circles = 1, expand.lims = 1.5,
  main = "intersphere: overlap diagram", onlySets = seq(length(data), 2, by
  = -1))
}
\arguments{
\item{data}{a list with n entries having elements that can be represented as sets (have union and intersect methods).}

\item{colors}{a character vector of  R build-in colors for circles representing different sets.}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{cex}{a numeric value giving the character expansion factor for intersect size text inside each circle.}

\item{expand.circles}{a numeric value giving the expansion factor of circles (multiplicative).}

\item{expand.lims}{a numeric value giving the expansion of x and y limits (additive).}

\item{main}{title(s) of the plot, standard graphics parameter.}

\item{onlySets}{vectors, which n-overlaps should be shown, default to all 1 < n < length(data).}
}
\description{
Create circles for visualizing overlaps between up to 4 datasets.
}
\examples{
data = list(
	"A" = sample(1:200,100),
	"B" = sample(1:200,150),
	"C" = sample(1:200,50))

intersphere(data,colors = c("orange","skyblue","green"))

data = list(
	"A" = sample(1:200,100),
	"B" = sample(1:200,150),
	"C" = sample(1:200,50),
	"D" = sample(1:200,75))

colors = c("orange","skyblue","green","purple")
intersphere(data,colors,expand.circles = 0.5,expand.lims = 0.5)
}
\author{
Sebastian Duemcke, Bjoern Schwalb
}
\seealso{
\code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\keyword{Venn}
\keyword{intersphere,}

