% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_corr.R
\name{comp.corr}
\alias{comp.corr}
\title{Computing corr}
\usage{
comp.corr(data, time, C)
}
\arguments{
\item{data}{a lagged matrix with rows representing genes and columns representing
different timepoints (NA's added when lags are needed)}

\item{time}{a lagged matrix with rows representing each gene's timepoint and columns representing the number of timepoints, NA is introduced when it is lagged}

\item{C}{a numeric value of C used in computing weighted correlation}
}
\value{
a simmilarity matrix with values between -1 and 1
(1 highly correlated, 0 no correlation)
}
\description{
This function computes the weighted correlation with a penalty for lags.
It should only be used after the fixed lags have already been applied to the dataset and timepoints using the functions
prep.data() and best.lag().
}
\examples{
comp.corr(array(rnorm(40), c(5, 8)), time = t(array(c(0, 5, 10, 15, 20, 25,
30, 35), c(8, 5))), C = 10)

}
\author{
Thevaa Chandereng, Anthony Gitter
}
