% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TDA.R
\name{get_kernel_matrix}
\alias{get_kernel_matrix}
\title{get_kernel_matrix}
\usage{
get_kernel_matrix(
  Diag = NULL,
  method = c("sWd", "pssk"),
  dimensions = NULL,
  return.dist = FALSE,
  M = NULL,
  sigma = NULL,
  ncpu = 1
)
}
\arguments{
\item{Diag}{list of persistence diagrams as n x 3 matrices}

\item{method}{which kernel or distance to compute. One of sWd (for sliced Wasserstein kernel) or pssk (for the persistence scale-space kernel)}

\item{dimensions}{vector of the dimensions of the topological features to consider, if NULL (default) use all available dimensions}

\item{return.dist}{logical (default: FALSE) for method sWd, whether to return the sliced Wasserstein distance matrix instead of the kernel.}

\item{M}{number of slices for the sliced Wasserstein kernel}

\item{sigma}{kernel bandwidth}

\item{ncpu}{number of parallel threads to use for computation}
}
\value{
a matrix
}
\description{
Compute kernel/distance matrix between persistence diagrams.
}
\examples{
PS <- list(data.frame(x = c(2.4,-6.9,4.6,-0.7,-3.3,-4.9,-3.5,-3.5,4.2,-7),
                      y = c(5.7,1.9,4.8,3.4,-3,-2.1,7.2,1.8,6.1,-1.6),
                      z = c(2.7,-0.1,-0.7,-0.6,0.4,-1.5,-0.6,-0.9,2.2,0.7)),
           data.frame(x = c(0,0,3.1,-5.6,-5,-7.4,-0.7,-7.7,-6.7,4,4.2,0.2,5.8,3.9,3.9),
                      y = c(6.3,-6.1,-3.5,4.6,-4.1,0.3,8.8,-2.3,2.9,3.7,-1.4,-3.9,5.5,-1.2,-6.7),
                      z = c(-1.5,1.7,-0.4,-1.4,1.8,1.7,-0.9,-1.8,-0.5,1.7,1.3,0.5,-1.4,1.6,-0.1)),
           data.frame(x = c(-9.8,-5.2,12.5,2.5,4.5,1.3,-0.2,0.4,9.3,-1.4,0.5,-1.1,-7.7),
                      y = c(-4.2,1.5,-0.5,12,-3,-7.2,10.9,6.7,-1.3,10,6.7,-6.2,2.9),
                      z = c(3.4,-3.8,-1.4,1.8,3.5,2.5,2.6,-4.8,-3.8,3.9,4.1,-3.6,-4)))
Dgs <- get_persistence_diagrams(point.sets = PS, maxdimension = 1, maxscale = 5, ncpu = 1)
K <- get_kernel_matrix(Diag = Dgs, method = 'sWd', dimensions = c(0,1), M = 10, sigma = 5)
}
