% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qln3.R
\name{qln3}
\alias{qln3}
\title{Quantile distribution function of Lognormal-3 Distribution}
\usage{
qln3(u = NULL, RP = 1/(1 - u), para)
}
\arguments{
\item{u}{non-exceedance probability}

\item{RP}{Return Period "don't use in case u is used"}

\item{para}{parameters as c(zeta, mu, sigma) that is c(lower bound, mean on log scale, standard deviation on log scale).}
}
\value{
Quantile value/s using the inverse of the cumulative distribution function.
}
\description{
Quantile distribution function of Lognormal-3 Distribution
}
\examples{

x <- qln3(u = 0.99, para = c(0, 0, 1))
x <- qln3(RP = 100, para = c(0, 0, 1))

}
\author{
Mohanad Zaghloul [aut, cre], Simon Michael Papalexiou [aut, ths], Amin Elshorbagy [aut, ths]
}
