% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.lmm}
\alias{plot.lmm}
\title{Graphical Display For Linear Mixed Models}
\usage{
\method{plot}{lmm}(
  x,
  type = "fit",
  type.residual = "normalized",
  by.time = TRUE,
  ci = TRUE,
  plot = TRUE,
  ci.alpha = 0.2,
  mean.size = c(3, 1),
  size.text = 16,
  ...
)
}
\arguments{
\item{x}{a \code{lmm} object.}

\item{type}{[character] the type of plot \itemize{
\item \code{"fit"}: fitted values over repetitions.
\item \code{"qqplot"}: quantile quantile plot of the normalized residuals
\item \code{"correlation"}: residual correlation over repetitions
\item \code{"scatterplot"}: normalized residuals vs. fitted values (diagnostic for missing non-linear effects),
\item \code{"scatterplot2"}: square root of the normalized residuals vs. fitted values (diagnostic for heteroschedasticity),
\item \code{"partial"}: partial residual plot.
}}

\item{type.residual}{[character] the type of residual to be used. Not relevant for \code{type="fit"}.
By default, normalized residuals are used except when requesting a partial residual plot.}

\item{by.time}{[logical] should a separate plot be made at each repetition or a single plot over all repetitions be used?
Only relevant for \code{type="qqplot"}, \code{type="scatterplot"}, and \code{type="scatterplot2"}.}

\item{ci}{[logical] should confidence intervals be displayed?}

\item{plot}{[logical] should the plot be displayed?}

\item{ci.alpha}{[numeric, 0-1] Transparency parameter used to display the confidence intervals.}

\item{mean.size}{[numeric vector of length 2] size of the point and line for the mean trajectory.}

\item{size.text}{[numeric, >0] size of the font used to displayed text when using ggplot2.}

\item{...}{additional argument passed to \code{residuals.lmm} or \code{autoplot.lmm}.}
}
\value{
A list with two elements \itemize{
\item \code{data}: data used to create the graphical display.
\item \code{plot}: ggplot object.
}
}
\description{
Display fitted values or residual plot for the mean, variance, and correlation structure.
Can also display quantile-quantile plot relative to the normal distribution.
}
\details{
Call \code{\link{autoplot.lmm}} when code{type=="fit"} and \code{\link{residuals.lmm}} for the other types.
}
\examples{
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")
dL$X1 <- as.factor(dL$X1)

eCS.lmm <- lmm(Y ~ visit + X1,
               repetition = ~visit|id, structure = "CS", data = dL, df = FALSE)
plot(eCS.lmm, type = "fit")
plot(eCS.lmm, type = "qqplot") ## engine.qqplot = "qqtest"
plot(eCS.lmm, type = "correlation") 
plot(eCS.lmm, type = "scatterplot") 
plot(eCS.lmm, type = "scatterplot2") 
plot(eCS.lmm, type = "partial", type.residual = "visit") 
plot(eCS.lmm, type = "partial", type.residual = "X1") 

}
