% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVarCov.R
\name{getVarCov}
\alias{getVarCov}
\alias{getVarCov.lmm}
\title{Extract The Residuals Variance-Covariance Matrix From a Linear Mixed Model}
\usage{
\method{getVarCov}{lmm}(
  obj,
  individual = NULL,
  p = NULL,
  simplifies = TRUE,
  strata = NULL,
  ...
)
}
\arguments{
\item{obj}{a \code{lmm} object.}

\item{individual}{[character, data.frame, NULL] identifier of the cluster(s) for which to extract the residual variance-covariance matrix.
For new clusters, a dataset containing the information (cluster, time, strata, ...) to be used to generate the residual variance-covariance matrices.
When \code{NULL}, will output complete data covariance patterns.}

\item{p}{[numeric vector] value of the model coefficients at which to evaluate the residual variance-covariance matrix. Only relevant if differs from the fitted values.}

\item{simplifies}{[logical] When there is only one variance-covariance matrix, output a matrix instead of a list of matrices.}

\item{strata}{[character vector] When not \code{NULL} and argument \code{individual} is not specified, only output the residual variance-covariance matrix relative to specific levels of the variable used to stratify the mean and covariance structure.}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
A list where each element contains a residual variance-covariance matrix.
Can also be directly a matrix when argument is \code{simplifies=TRUE} and there is a single residual variance-covariance matrix.
}
\description{
Extract the unique set of residuals variance-covariance matrices or the one relative to specific clusters.
}
\examples{
## simulate data in the long format
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")

## fit Linear Mixed Model
eUN.lmm <- lmm(Y ~ X1 + X2 + X5, repetition = ~visit|id, structure = "UN", data = dL, df = FALSE)

## extract residuals variance covariance matrix
getVarCov(eUN.lmm) ## unique patterns
getVarCov(eUN.lmm, individual = c("1","5")) ## existing individuals
getVarCov(eUN.lmm, individual = dL[1:7,,drop=FALSE]) ## new individuals
}
