% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize}
\alias{summarize}
\title{Compute summary statistics}
\usage{
summarize(
  formula,
  data,
  na.action = stats::na.pass,
  na.rm = FALSE,
  which = c("observed", "missing", "mean", "sd", "min", "median", "max", "correlation")
)
}
\arguments{
\item{formula}{[formula] on the left hand side the outcome(s) and on the right hand side the grouping variables.
E.g. Y1+Y2 ~ Gender + Gene will compute for each gender and gene the summary statistics for Y1 and for Y2.
Passed to the \code{stats::aggregate} function.}

\item{data}{[data.frame] dataset (in the wide format) containing the observations.}

\item{na.action}{[function] a function which indicates what should happen when the data contain 'NA' values.
Passed to the \code{stats::aggregate} function.}

\item{na.rm}{[logical] Should the summary statistics be computed by omitting the missing values.}

\item{which}{[character vector] name of the summary statistics to kept in the output.
Can be any of, or a combination of: \code{"observed"} (number of observations with a measurement),
\code{"missing"} (number of observations with a missing value), \code{"mean"}, \code{"sd"}, \code{"min"}, \code{"median"}, \code{"max"}.}
}
\value{
a data frame containing summary statistics (in columns) for each outcome and value of the grouping variables (rows). It has an attribute \code{"correlation"} when it was possible to compute the correlation matrix for each outcome with respect to the grouping variable.
}
\description{
Compute summary statistics (similar to the SAS macro procmean).
This is essentially an interface to the \code{stats::aggregate} function.
}
\examples{
## simulate data in the wide format
set.seed(10)
d <- sampleRem(1e2, n.times = 3)

## add a missing value
d2 <- d
d2[1,"Y2"] <- NA

## run summarize
summarize(Y1+Y2 ~ 1, data = d)
summarize(Y1+Y2 ~ X1, data = d)

summarize(Y1+Y2 ~ X1, data = d2)
summarize(Y1+Y2 ~ X1, data = d2, na.rm = TRUE)

## long format
dL <- reshape2::melt(d, id.vars = c("id","X1"), measure.var = c("Y1","Y2","Y3"))
dL2 <- dL[-(4:5),]

summarize(value ~ variable + X1, data = dL)

## compute correlations
e.S <- summarize(value ~ variable + X1 | id, data = dL2, na.rm = TRUE)
e.S
attr(e.S, "correlation")
}
