% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmm.R
\name{lmm}
\alias{lmm}
\title{Fit Linear Mixed Model}
\usage{
lmm(
  formula,
  repetition,
  structure,
  data,
  method.fit = NULL,
  df = NULL,
  type.information = NULL,
  trace = NULL,
  control = NULL
)
}
\arguments{
\item{formula}{[formula] Specify the model for the mean.
On the left hand side the outcome and on the right hand side the covariates affecting the mean value.
E.g. Y ~ Gender + Gene.}

\item{repetition}{[formula] Specify the model for the covariance.
On the right hand side the time/repetition variable and the grouping variable, e.g. ~ time|id.
On the left hand side, a possible stratification variable, e.g. group ~ time|id. In that case the mean structure should only be stratified on this variable using interactions.}

\item{structure}{[character] type of covariance structure, either \code{"CS"} (compound symmetry) or \code{"UN"} (unstructured).}

\item{data}{[data.frame] dataset (in the long format) containing the observations.}

\item{method.fit}{[character] Should Restricted Maximum Likelihoood (\code{"REML"}) or Maximum Likelihoood (\code{"ML"}) be used to estimate the model parameters?}

\item{df}{[logical] Should the degree of freedom be computed using a Satterthwaite approximation?}

\item{type.information}{[character] Should the expected information be computed  (i.e. minus the expected second derivative) or the observed inforamtion (i.e. minus the second derivative).}

\item{trace}{[interger, >0] Show the progress of the execution of the function.}

\item{control}{[list] Control values for the optimization method. The element \code{optimizer} indicates which optimizer to use and additional argument will be pass to the optimizer.}
}
\value{
an object of class \code{lmm} containing the estimated parameter values, the residuals, and relevant derivatives of the likelihood.
Compatible with standard methods such as \code{summary}, \code{autoplot}, \code{confint}, \code{coef}, \code{anova}, \code{predict}, \code{residuals}.
}
\description{
Fit a multivariate gaussian model using either a compound symmetry structure or an unstructured covariance matrix.
This is essentially an interface to the \code{nlme::gls} function.
}
\details{
\bold{Computation time} the \code{lmm} has not been developped to be a fast function as, by default, it uses REML estimation with the observed information matrix and uses a Satterthwaite approximation to compute degrees of freedom (this require to compute the third derivative of the log-likelihood which is done by numerical differentiation). The computation time can be substantially reduced by using ML estimation with the expected information matrix and no calculation of degrees of freedom: arguments \code{method.fit="ML"}, \code{type.information="expected"}, \code{df=FALSE}. This will, however, lead to less accurate p-values and confidence intervals in small samples.
}
\examples{
## simulate data in the long format
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")

## fit Linear Mixed Model
eCS.lmm <- lmm(Y ~ X1 + X2 + X5, repetition = ~visit|id, structure = "CS", data = dL)
eCS.lmm
summary(eCS.lmm)
}
