% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mrchk.R
\name{mrchk}
\alias{mrchk}
\alias{mrchk.default}
\title{Merchuk's Equation to fit Binodal Experimental Data}
\usage{
mrchk(XYdt, ...)

\method{mrchk}{default}(XYdt, P1 = 10, P2 = 1, P3 = 0, ...)
}
\arguments{
\item{XYdt}{- Binodal Experimental data that will be used in the nonlinear fit}

\item{...}{Additional optional arguments. None are used at present.}

\item{P1,P2,P3}{Merchuk's Parameters}
}
\value{
Parameters P and Statistical data

Parameters P and Statistical data
}
\description{
Merchuk et al. published a paper in the Journal of 'Chromatography B: Biomedical Sciences and Applications'
relating the use of a nonlinear equation to fit and study phase inversion and protein separation using a PEG400/Phosphate
Aqueous Two-Phase System. They also calculated Tieline composition by using a set of four equations and the relationship
of Tieline's Slope with tielines parameters. This R method implements the methodology described in the referred article.

Perform a nonlinear regression fit in order to determine the equation's parameters.
}
\details{
The function returns three parameters after fitting experimental data to the equation proposed by Merchuk et al.
}
\examples{
#Populating variable XYdt with binodal data
XYdt <- peg4kslt[,1:2]
#Fitting XYdt using Merchuk's function
mrchk(XYdt)
}
\references{
Merchuk, J.C., B.A. Andrews, and J.A. Asenjo, Aqueous two-phase systems for protein separation: Studies on
phase inversion. Journal of Chromatography B: Biomedical Sciences and Applications, 1998. 711(1-2): p. 285-293.
}
\seealso{
\itemize{
\item \code{\link{mrchk.default}}
\item \code{\link{mrchk.plot}}
\item \code{\link{mrchk.tielines}}
\item \code{\link{mrchk.crpt}}
\item \code{\link{gsnchk}}
}
}

