% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLIC.R
\name{LLIC}
\alias{LLIC}
\title{LLIC for Lre Model}
\usage{
LLIC(X, y, alpha, K)
}
\arguments{
\item{X}{Design matrix}

\item{y}{Random response vector of observed values}

\item{alpha}{Significance level}

\item{K}{Number of subsets}
}
\value{
A list containing the following components:
\item{MUopt}{A vector of the means of the predictor variables in the optimal subset.}
\item{Bopt}{A vector of the estimated regression coefficients from the final model fitted to the optimal subset.}
\item{MAEMUopt}{The Mean Absolute Error (MAE) for the optimal subset.}
\item{MSEMUopt}{The Mean Squared Error (MSE) for the optimal subset.}
\item{opt}{Currently NULL, a placeholder for potential future use.}
\item{Yopt}{A vector of the predicted values from the final model fitted to the optimal subset.}
}
\description{
This function carries out an Laplace LIC analysis utilizing the Lre model.
}
\examples{
set.seed(12)
library(VGAM)
X <- matrix(data = sample(1:3, 1200 * 5, replace = TRUE), nrow = 1200, ncol = 5)
b <- sample(1:3, 5, replace = TRUE)
e <- rlaplace(1200, 0, 1)
Y <- X \%*\% b + e
alpha <- 0.05
K <- 10
result <- LLIC(X, Y, alpha, K)
MUopt <- result$MUopt
Bopt <- result$Bopt
MAEMUopt <- result$MAEMUopt
MSEMUopt <- result$MSEMUopt
opt <- result$opt
Yopt <- result$Yopt

}
