% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LOO.R
\name{LOO}
\alias{LOO}
\title{Leave-one-out Method}
\usage{
LOO(n, k, h = sample(seq(from = 1, to = n), k), method = "manhattan")
}
\arguments{
\item{n}{A positive integer, which stands for the number of rows (or run size).}

\item{k}{A positive integer, which stands for the number of columns (or factor size). \code{k} must be smaller than \code{n+1}.}

\item{h}{A vector whose length is \code{k}, with its elements that are smaller than and coprime to \code{n+1}. The default is set to be a random sample of \code{k} elements between 1 and \code{n}.}

\item{method}{A distance measure method. The default setting is "manhattan", and it could be one of the following: "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski". Any unambiguous substring can be given.}
}
\value{
If all inputs are logical, then the output will be a list, which contains a \code{n} by \code{k} LHD and its maximum minimum L_1 distance. This is the construction method in section 2.2 of the reference, and it is particularly useful when \code{n+1} is prime and \code{k} equals \code{n}.
}
\description{
\code{LOO} returns a maximin distance LHD matrix generated by Leave-one-out method, along with its maximum minimum L_1 distance
}
\examples{
#generate a 10 by 10 maximin distance LHD with default setting
try=LOO(n=10,k=10)
try
phi_p(try[[1]])   #calculate the phi_p of "try".

#Another example
#generate a 12 by 12 maximin distance LHD with given h vector
try2=LOO(n=12,k=12,h=1:12)
try2
phi_p(try2[[1]])   #calculate the phi_p of "try2".

}
\references{
Wang, L., Xiao, Q., and Xu, H. (2018)  Optimal maximin $L_{1}$-distance Latin hypercube designs based on good lattice point designs. \emph{The Annals of Statistics}, \strong{46}(6B), 3741-3766.
}
