% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_RF_INTERACTION_TRANSFORMER.R
\name{rf.interaction.transformer}
\alias{rf.interaction.transformer}
\title{Extract interactions from random forest}
\usage{
rf.interaction.transformer(
  db,
  rf,
  target,
  num.rf = NA,
  num.tree,
  min.pct.obs,
  min.avg.rate,
  max.depth,
  monotonicity,
  create.interaction.rf,
  seed = 991
)
}
\arguments{
\item{db}{Data frame of risk factors and target variable supplied for interaction extraction.}

\item{rf}{Character vector of risk factor names on which decision tree is run.}

\item{target}{Name of target variable within db argument.}

\item{num.rf}{Number of risk factors randomly selected for each decision tree. If default value (\code{NA}) is supplied,
then number of risk factors will be calculated as \code{sqrt(number of all supplied risk factors)}.}

\item{num.tree}{Number of decision trees used for random forest.}

\item{min.pct.obs}{Minimum percentage of observation in each leaf.}

\item{min.avg.rate}{Minimum average target rate in each leaf.}

\item{max.depth}{Maximum number of splits.}

\item{monotonicity}{Logical indicator. If \code{TRUE}, observed trend between risk factor and target will be preserved
in splitting node.}

\item{create.interaction.rf}{Logical indicator. If \code{TRUE}, second element of the output will be data frame with
interaction modalities.}

\item{seed}{Random seed to ensure result reproducibility. Default is 991.}
}
\value{
The command \code{rf.interaction.transformer} returns a list of two data frames. The first data frame provides
the trees summary. The second data frame is a new risk factor extracted from random forest.
}
\description{
\code{rf.interaction.transformer} extracts the interactions from random forest.
It implements customized random forest algorithm that takes into account different conditions (for single decision tree) such as minimum
percentage of observations and defaults in each node, maximum tree depth and monotonicity condition
at each splitting node. Sum of squared errors index is used as metric for node splitting .
}
\examples{
library(LGDtoolkit)
data(lgd.ds.c)
rf.it <- LGDtoolkit::rf.interaction.transformer(db = lgd.ds.c, 
		     rf = names(lgd.ds.c)[!names(lgd.ds.c)\%in\%"lgd"], 
		     target = "lgd",
		     num.rf = NA, 
		     num.tree = 3,
		     min.pct.obs = 0.05,
		     min.avg.rate = 0.01,
		     max.depth = 2,
		     monotonicity = TRUE,
		     create.interaction.rf = TRUE,
		     seed = 789)
names(rf.it)
rf.it[["tree.info"]]
tail(rf.it[["interaction"]])
table(rf.it[["interaction"]][, 1], useNA = "always")
}
