% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsK.R
\name{plotAIP_HDLVrnc}
\alias{plotAIP_HDLVrnc}
\title{Plots AIP variance versus increasing HDL variance}
\usage{
plotAIP_HDLVrnc(dfHDLVars, AIPVrncErrProp, AIPVrncErrProp2Ord, AIPbootVrnc)
}
\arguments{
\item{dfHDLVars}{A data frame with increasing variances of HDL.}

\item{AIPVrncErrProp}{A vector with the first order error propagation
variances of AIP when the HDL variance increases.}

\item{AIPVrncErrProp2Ord}{A vector with the second order error propagation
variances of AIP when the HDL variance increases.}

\item{AIPbootVrnc}{A vector with the bootstrap
variances of AIP when the triglyceride variance increases.}
}
\value{
The function creates a plot with the AIP error propagation and
bootstrap variances versus increasing  triglyceride variance.
}
\description{
Plots the variance of AIP (both Error Propagation first and
second order, as well as Bootstrap variance) versus increasing HDL variance.
}
\examples{
\donttest{
HDLVariances = CV_Range(sampleA$HDL,15,25,plot=FALSE)
AIPVrncChngHDLVrnc = AIP_HDLVrnc(HDLVariances,sampleA$TG, bootStrpReps=2000)
HDLErrPropVrnc = AIPVrncChngHDLVrnc$ErrPropVrnc
HDLErrPropVrnc2Ord = AIPVrncChngHDLVrnc$ErrPropVrnc2Ord
HDLBootVrnc = AIPVrncChngHDLVrnc$BootVrnc
plotAIP_HDLVrnc(HDLVariances,HDLErrPropVrnc,HDLErrPropVrnc2Ord,HDLBootVrnc)
}
}
