% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{sim_TS_data}
\alias{sim_TS_data}
\title{Simulate TS data from a TS model structure given parameters}
\usage{
sim_TS_data(X, Eta, rho, tD, err = 0, seed = NULL)
}
\arguments{
\item{X}{\code{matrix} of covariates, dimension M (number of documents) x 
SC (number of segments x number of covariates, including the intercept).}

\item{Eta}{\code{matrix} of regression parameters across the segments,
dimension: SC (number of segments x number of covariates, including the
intercept) x k (number of topics).}

\item{rho}{Vector of integer-conformable time locations of changepoints or 
\code{NULL} if no changepoints. Used to determine the number of 
segments. Must exist within the bounds of the times of the documents,
\code{tD}.}

\item{tD}{Vector of integer-conformable times of the documents. Must be
of length M (as determined by \code{X}).}

\item{err}{Additive error on the link-scale. Must be a non-negative 
\code{numeric} value. Default value of \code{0} indicates no error.}

\item{seed}{Input to \code{\link{set.seed}}.}
}
\value{
A document-by-topic \code{matrix} of probabilities (dim: M x k).
}
\description{
For a given set of covariates \code{X}; parameters \code{Eta},
  \code{rho}, and \code{err}; and document-specific time stamps \code{tD},
  simulate a document-by-topic matrix. Additional structuring variables 
  (numbers of topics (k), documents (M), segments (S), and 
  covariates per segment (C)) are inferred from input objects.
}
\examples{
  tD <- c(1, 3, 4, 6)
  rho <- 3
  X <- matrix(c(1,1,0,0,1,2,0,0,0,0,1,3,0,0,1,4), 
         nrow = length(tD), ncol = 4, byrow = TRUE)
  Eta <- matrix(c(0.5, 1.2, 0.3, 1.1, 0.9, 0.1, 0.5, 0.5), 
          nrow = ncol(X), ncol = 2, byrow = TRUE)
  sim_TS_data(X, Eta, rho, tD, err = 1)
  
}
