% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize.community}
\alias{visualize.community}
\title{visualize ego gene X, its k step neighbours, and the W gene communities: Generate a graph
with different community in different colors.
\code{visualize.community()}is used to create a graph to display the layout of genes X, X's k-step neighborhood, W and their corresponding community.}
\usage{
visualize.community(graph, kernel.result, x, k = 2, cutoff = 1,
  community.min = 5, path = NULL)
}
\arguments{
\item{graph}{The igraph object of gene network.}

\item{kernel.result}{The result of graph.kd which finds genes W of a gene X.}

\item{x}{The gene the plot is generated for.}

\item{k}{The degree of the neighborhood of X.}

\item{cutoff}{A threshold to filter gene W.}

\item{community.min}{The minimum size of the community of W.}

\item{path}{The path where the result graph is saved to. The default path is the original path of input graph.}
}
\value{
a graph displays genes X, X's k-step neighborhood, and W gene communities in different colors.
}
\description{
visualize ego gene X, its k step neighbours, and the W gene communities: Generate a graph
with different community in different colors.
\code{visualize.community()}is used to create a graph to display the layout of genes X, X's k-step neighborhood, W and their corresponding community.
}
\examples{
\dontrun{
kernel <- graph.kd(relate.matrix,g,smoothing.normalize = "one")
visualize(g,kernel,x,k=2,cutoff=1,community.min=5,path=NULL)}
}

