% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LAGOSNE-package.R
\docType{data}
\name{conn}
\alias{conn}
\alias{connectivity}
\alias{buffer500m.conn}
\alias{iws.conn}
\alias{hu12.conn}
\alias{hu8.conn}
\alias{hu4.conn}
\alias{edu.conn}
\alias{county.conn}
\alias{state.conn}
\title{Connectivity Datasets}
\format{
Data frames with all or a subset of the following variables. Number
of observations is equal to the number of zones in each spatial
classification (see ?classifications). Wildcard options include a subset of
the LAGOSNE spatial classifications (* = buffer500m, iws,
hu12, hu8, hu4, edu, county, state) and additional wildcards described
below.
\itemize{
     \item Identifiers and Zone Metadata
     \itemize{
         \item *_zoneid: unique zone identifier
         \item *_nwiexclusions: zones that are not completely covered by
         the National Wetlands Inventory
         }
     \item Lake Connectivity Metrics. Lake abundance metrics are derived for
     all lakes, isolated lakes ("isolated" - no inflow or outflow streams),
     headwater lakes ("headwater" - no inflowing streams), stream
     drainage lakes ("drstream" - lakes with inflowing stream(s), with or
     without outflows, and no upstream lakes greater than 10 ha), and lake
     drainage lakes ("drlakeStream" lakes with inflowing stream(s) and at
     least one upstream lake greater than 10 ha).
     \itemize{
         \item *_lakes_**_***: all lakes that are within or intersect the
         zone boundary and are in a particular size class (** = lakes4ha,
         lakes4to10ha, lakes10ha), expressed as average lake area
         (*** = agsize_ha) or count (** = count)
         \item *_lakes_**_overlapping_***: all lakes that are clipped to the
         zone boundary and are in a particular size class (** = lakes4ha,
         lakes4to10ha, lakes10ha), expressed as sum of lake area
         (*** = area_ha) or percent of zone area (*** = area_pct)
         \item *_lakes_**_contributing_area_ha: all lakes that are within or
         intersect the zone boundary, and are in a particular size class
         (** = lakes4ha, lakes4to10ha, lakes10ha), expressed as sum of lake
          area
         \item *_lakes_**_isolated_***: all isolated lakes that are within
         or intersect the zone boundary, and are in a particular size class
         (** = lakes4ha, lakes4to10ha, lakes10ha), expressed as average size
          in hectares (*** = avgsize_ha) or count (*** = count
         \item *_lakes_**_isolated_overlapping_***: all isolated lakes that
         are clipped to the zone boundary and are in a particular size class
         (** = lakes4ha, lakes4to10ha, lakes10ha), expressed as sum of lake
         area (*** = area_ha) or percent of zone area (*** = area_pct)
         \item *_lakes_**_isolated_contributing_area_ha: all isolated lakes
         that are within or intersect the zone boundary, and are in a
         particular size class (** = lakes4ha, lakes4to10ha, lakes10ha),
         expressed as sum of lake area
         \item *_lakes_**_headwater_***: all headwater lakes that are within
         or intersect the zone boundary, and are in a particular size class
         (** = lakes4ha, lakes4to10ha, lakes10ha), expressed as average
         size in hectares (*** = avgsize_ha) or count (*** = count
         \item *_lakes_**_headwater_overlapping_***: all headwater lakes
         that are clipped to the zone boundary and are in a particular size
         class (** = lakes4ha, lakes4to10ha, lakes10ha), expressed
         as sum of lake area (*** = area_ha) or percent of zone area
         (*** = area_pct)
         \item *_lakes_**_headwater_contributing_area_ha: all headwater
         lakes that are within or intersect the zone boundary, and are in a
         particular size class (** = lakes4ha, lakes4to10ha, lakes10ha),
         expressed as sum of lake area
         \item *_lakes_**_drstream_***: all drstream lakes that are within
         or intersect the zone boundary, and are in a particular size class
         (** = lakes4ha, lakes4to10ha, lakes10ha), expressed as average
         size in hectares (*** = avgsize_ha) or count (*** = count
         \item *_lakes_**_drstream_overlapping_***: all drstream lakes that
         are clipped to the zone boundary and are in a particular size class
         (** = lakes4ha, lakes4to10ha, lakes10ha), expressed as sum of lake
         area (*** = area_ha) or percent of zone area (*** = area_pct)
         \item *_lakes_**_drstream_contributing_area_ha: all drstream lakes
         that are within or intersect the zone boundary,
         and are in a particular size class (** = lakes4ha, lakes4to10ha,
          lakes10ha), expressed as sum of lake area
         \item *_lakes_**_drlakestream_***: all drlakestream lakes that are
         within or intersect the zone boundary, and are in a particular size
         class (** = lakes4ha, lakes4to10ha, lakes10ha), expressed
         as average size in hectares (*** = avgsize_ha) or
         count (*** = count
         \item *_lakes_**_drlakestream_overlapping_***: all drlakestream
         lakes that are clipped to the zone boundary and are in a particular
         size class (** = lakes4ha, lakes4to10ha,
         lakes10ha), expressed as sum of lake area (*** = area_ha) or
         percent of zone area (*** = area_pct)
         \item *_lakes_**_drlakestream_contributing_area_ha: all
         drlakestream lakes that are within or intersect the zone boundary,
         and are in a particular size class (** = lakes4ha, lakes4to10ha,
         lakes10ha), expressed as sum of lake area
         \item *_latewisconsinglaciation_glaciation: zone glaciation status
         during  the late Wisconsin glaciation (Glaciated, Not_Glaciated,
          Partially)
     }
     \item Stream Connectivity Metrics
     \itemize{
         \item *_streamdensity_streams_**: all streams (NHDFlowline minus
         artificial lines through lakes)
         within the zone expressed as sum of length in meters
         (** = sum_lengthm) or density in meters per hectare (** = mperha)
         \item *_streamdensity_headwaters_*: headwater streams
         (1st-3rd Strahler order) within the zone
         expressed as sum of length in meters (** = sum_lengthm) or density
         in meters per hectare (** = mperha)
         \item *_streamdensity_midreaches_*: Midreach streams
         (4th-6th Strahler order) within the zone
         expressed as sum of length in meters (** = sum_lengthm) or density
         in meters per hectare (** = mperha)
         \item *_streamdensity_rivers_*: large river-streams (>6th Strahler
         order) within the zone
         expressed as sum of length in meters (** = sum_lengthm) or density
         in meters per hectare (** = mperha)
         \item *_canalditchdensity_**: canals within the zone,
         expressed as sum of length in meters (** = sum_lengthm) or density
         in meters per hectare (** = mperha)
         }
     \item Wetland Connectivity Metrics
     \itemize{
         \item *_wl_allwetlandsdissolved_**: all wetlands (regardless of
         vegetation,
         connection, or regime), expressed as average size in hectares
         (** = avgsize_ha), total area of wetlands that is contained within
         or partially intersect the border of this zone
         (** = overlapping_area_ha),
         total land area of this zone that is covered by all wetlands
         (** = contributing_area_ha),
         or percent of land area of this zone that is covered by all
         wetlands (** = overlapping_area_pct).
         Before calculating this value, contiguous patches of different
         types of wetlands were first dissolved to represent a single patch.
         \item *_wl_allwetlandsundissolved_**: all wetlands (regardless of
         vegetation, connection, or regime), expressed as count
         (** = count), average size in hectares (** = avgsize_ha), total
         area of wetlands that is contained within or partially intersect
         the border of this zone (** = overlapping_area_ha), total land area
         of this zone that is covered by all wetlands
         (** = contributing_area_ha), or percent of land area of this zone
         that is covered by all wetlands (** = overlapping_area_pct).
         Before calculating this value, contiguous patches of different
         types of wetlands were first dissolved to represent a single patch.
         \item *_wl_isolatedwetlandsundissolved_**: isolated wetland patches
         (no intersecting streams within a 30 m buffer of the wetland patch)
         in this zone.all wetlands (regardless of vegetation, connection,
         or regime), expressed as count (** = count), average size in
         hectares (** = avgsize_ha), total area of wetlands that
         is contained within or partially intersect the border of this zone
         (** = overlapping_area_ha), total land area of this zone that is
         covered by this wetland type (** = contributing_area_ha), or
         percent of land area of this zone that is covered by this wetland
         type (** = overlapping_area_pct).
         The patches were left as delineated by the National Wetlands
         Inventory ("undissolved") for calculating this variable.
         \item *_wl_singlewetlandsundissolved_**:  single wetland patches
         (intersected within a 30 m buffer
         by a single first order stream) in this zone, expressed as count
         (** = count), average size in hectares (** = avgsize_ha), total
         area of wetlands that
         is contained within or partially intersect the border of this zone
         (** = overlapping_area_ha),
         total land area of this zone that is covered by this wetland type
         (** = contributing_area_ha),
         or percent of land area of this zone that is covered by this
         wetland type (** = overlapping_area_pct).
         The patches were left as delineated by the National Wetlands
         Inventory ("undissolved") for calculating this variable.
         \item *_wl_connectedwetlandsundissolved_**: connected wetland
         patches (intersected within a 30 m buffer by a higher
         order stream or by multiple streams) in this zone, expressed as
         count (** = count), average size in hectares (** = avgsize_ha),
         total area of wetlands that
         is contained within or partially intersect the border of this zone
         (** = overlapping_area_ha),
         total land area of this zone that is covered by this wetland type
         (** = contributing_area_ha),
         or percent of land area of this zone that is covered by this
         wetland type (** = overlapping_area_pct).
         The patches were left as delineated by the National Wetlands
         Inventory ("undissolved") for calculating this variable.
         \item *_wl_forestedwetlandsundissolved_**:  forested wetland
         patches (dominated by woody vegetation 6m or taller)  in this zone,
         expressed as count (** = count), average size in hectares
         (** = avgsize_ha), total area of wetlands that
         is contained within or partially intersect the border of this zone
         (** = overlapping_area_ha),
         total land area of this zone that is covered by this wetland type
         (** = contributing_area_ha),
         or percent of land area of this zone that is covered by this
         wetland type (** = overlapping_area_pct).
         The patches were left as delineated by the National Wetlands
         Inventory ("undissolved") for calculating this variable.
         \item *_wl_scrubshrubwetlandsundissolved_**: scrub-shrub wetland
         patches (dominated by woody vegetation < 6m tall) in this zone,
         expressed as count (** = count), average size in hectares
         (** = avgsize_ha), total area of wetlands that
         is contained within or partially intersect the border of this zone
         (** = overlapping_area_ha),
         total land area of this zone that is covered by this wetland type
         (** = contributing_area_ha),
         or percent of land area of this zone that is covered by this
         wetland type (** = overlapping_area_pct).
         The patches were left as delineated by the National Wetlands
         Inventory ("undissolved") for calculating this variable.
         \item *_wl_openwaterwetlandsundissolved_**:  open water wetland
         patches (dominated by woody vegetation < 6m tall)  in this zone,
         expressed as count (** = count), average size in hectares
         (** = avgsize_ha), total area of wetlands that
         is contained within or partially intersect the border of this zone
         (** = overlapping_area_ha),
         total land area of this zone that is covered by this wetland type
         (** = contributing_area_ha),
         or percent of land area of this zone that is covered by this
         wetland type (** = overlapping_area_pct).
         The patches were left as delineated by the National Wetlands
         Inventory ("undissolved") for calculating this variable.
         \item *_wl_regimefwetlandsundissolved_**: regime f
         (semipermanently flooded) wetland patches where surface water
         persists throughout the growing season in most years, expressed as
         count (** = count), average size in hectares (** = avgsize_ha),
         total area of wetlands that
         is contained within or partially intersect the border of this zone
         (** = overlapping_area_ha),
         total land area of this zone that is covered by this wetland type
         (** = contributing_area_ha),
         or percent of land area of this zone that is covered by this
         wetland type (** = overlapping_area_pct).
         The patches were left as delineated by the National Wetlands
         Inventory ("undissolved") for calculating this variable.
         \item *_wl_regimegwetlandsundissolved_**: regime g (intermittently
         exposed) wetland patches where surface water persists
         throughout the growing season in most years, expressed as count
         (** = count), average size in hectares (** = avgsize_ha), total
         area of wetlands that
         is contained within or partially intersect the border of this zone
         (** = overlapping_area_ha),
         total land area of this zone that is covered by this wetland type
         (** = contributing_area_ha),
         percent of land area of this zone that is covered by this wetland
         type (** = overlapping_area_pct).
         The patches were left as delineated by the National Wetlands
         Inventory ("undissolved") for calculating this variable.
         \item *_wl_regimeawetlandsundissolved_**: regime a (temporarily
         flooded) wetland patches where surface water persists
         throughout the growing season in most years, expressed as count
         (** = count), average size in hectares (** = avgsize_ha), total
         area of wetlands that is contained within or partially intersect
         the border of this zone (** = overlapping_area_ha),
         total land area of this zone that is covered by this wetland type
         (** = contributing_area_ha),
         or percent of land area of this zone that is covered by this
         wetland type (** = overlapping_area_pct).
         The patches were left as delineated by the National Wetlands
         Inventory ("undissolved") for calculating this variable.
         \item *_wl_regimecwetlandsundissolved_**: regime c (seasonally
         flooded) wetland patches where surface water persists
         throughout the growing season in most years, expressed as count
         (** = count), average size in hectares (** = avgsize_ha), total
         area of wetlands that
         is contained within or partially intersect the border of this zone
         (** = overlapping_area_ha),
         total land area of this zone that is covered by this wetland type
         (** = contributing_area_ha),
         or percent of land area of this zone that is covered by this
         wetland type (** = overlapping_area_pct).
         The patches were left as delineated by the National Wetlands
         Inventory ("undissolved") for calculating this variable.
         \item *_wl_regimehwetlandsundissolved_**: regime h (permanently
         flooded) wetland patches where surface water persists
         throughout the growing season in most years, expressed as count
         (** = count), average size in hectares (** = avgsize_ha), total
         area of wetlands that
         is contained within or partially intersect the border of this zone
         (** = overlapping_area_ha),
         total land area of this zone that is covered by this wetland type
         (** = contributing_area_ha),
         or percent of land area of this zone that is covered by this
         wetland type (** = overlapping_area_pct).
         The patches were left as delineated by the National Wetlands
         Inventory ("undissolved") for calculating this variable.

    }
}
}
\description{
Datasets containing lake, stream, and wetland abundance and connectivity
 metrics calculated at the 500m buffer (buffer500m.conn), HUC12
  (hu12.conn), HUC8 (hu8.conn), HUC4 (hu4.conn), EDU (edu.conn), county
   (county.conn) and state (state.conn) classifications.
}
\references{
Soranno et al. (2017) \href{https://doi.org/10.1093/gigascience/gix101}{Gigascience 6:12}
}
\seealso{
\code{\link[LAGOSNE]{lakes.geo}}
}
\keyword{datasets}
