% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictKspm.R
\name{predict.kspm}
\alias{predict.kspm}
\title{Predicting Kernel Semi parametric Model Fits}
\usage{
\method{predict}{kspm}(object, newdata.linear = NULL,
  newdata.kernel = NULL, interval = "none", level = 0.95, ...)
}
\arguments{
\item{object}{an object of class "kspm", usually, a result of a call to \code{kspm}.}

\item{newdata.linear}{should be a data frame or design matrix of variables used in the linear part}

\item{newdata.kernel}{a list containing data frame or design matrix of variables used in each kernel part depending on the specification format of each kernel. When a kernel has been specified using \code{kernel.function = "gram.matrix"} in \code{Kernel} function, the user should also provide the Gram matrix associated to the new data points in \code{newdata.kernel}. The function \link{info.kspm} may help to correctly specify it.}

\item{interval}{type of interval calculation. If \code{"none"} (default), no interval is computed, if \code{"confidence"}, the confidence interval is computed, if \code{"prediction"}, the prediction interval is computed.}

\item{level}{confidence level. Default is \code{level = 0.95} meaning 95\% confidence/prediction interval.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{predict.kspm} returns a vector of predictions or a matrix containing the following components if \code{interval} is set:
  \item{fit}{predictions.}
  \item{lwr}{lower bound of confidence/prediction intervals.}
  \item{upr}{upper bound of confidence/prediction intervals.}
}
\description{
predict method for class "kspm".
}
\details{
\code{predict.kspm} produces predicted values. If a new dataset is not specified, it will return the fitted values from the original data. If \code{predict.kspm} is applied to a new dataset, all variables used in the original model should be provided in  \code{newdata.linear} and \code{newdata.kernel} arguments. Setting \code{interval} specifies computation of confidence or prediction intervals at the specified \code{level}.
}
\examples{
x <- 1:15
z1 <- runif(15, 1, 6)
z2 <- rnorm(15, 1, 2)
y <- 3*x + (z1 + z2)^2 + rnorm(15, 0, 2)
fit <- kspm(y, linear = ~ x, kernel = ~ Kernel(~ z1 + z2,
kernel.function = "polynomial", d= 2, rho = 1, gamma = 0))
predict(fit, interval = "confidence")

}
\seealso{
\link{kspm}, \link{summary.kspm}.
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
