% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MKMO.R
\name{MKMO}
\alias{MKMO}
\title{Optimal KM for Quantitative Traits in Multivariate GWAS Data (calculate p-value)}
\usage{
MKMO(
  obj,
  genotypes,
  gid,
  weights = NULL,
  acc = 1e-04,
  acc2 = 1e-04,
  r.all = c(0, 0.25, 0.5, 0.75, 1),
  append.write = NULL,
  eq.gen.effect = F
)
}
\arguments{
\item{obj}{results saved from MKMO_Null_Model.}

\item{genotypes}{1st column: gene name; 2nd column: snp name; 3rd-end columns: A matrix of genotypes for each subject (class: data.frame). The order of 3rd-end columns should match unique(yid). Coded as 0, 1, 2 and no missing. This genotype file can be a big file containing all genes or it can be files containing one single gene.}

\item{gid}{A vector of id mapping to samples in genotype file (class: vector). So the order of samples in gid must be the same as the order in genotypes. Make sure it is not a factor. Although gid doesn't have to be in the same order as yid, it is suggested to make them sorted in the same order in order to make all files easily to be tracked. No missing.}

\item{weights}{1st column: gene name; 2nd column: snp name; 3rd column: A vector with the length equal to the number of variants in the test (class: data.frame). Default is Null indicating equal weight for all markers}

\item{acc}{Accuracy of numerical integration used in Davies' method for individual r.all p-values. Default 1e-4.}

\item{acc2}{Accuracy of numerical integration used in Davies' method for the final p-value. Default 1e-4.}

\item{r.all}{A list of predefined proportion of linear kernel and burden test. When r.all=0, regular kernel machine test (MKM); when r.all=1, burden test.}

\item{append.write}{The name of pvalue output file. Write out p-values in real time. Don't need to wait until all genes are processed to get the final output.}

\item{eq.gen.effect}{Whether assume equal genetic effects on different traits (default = False).}
}
\value{
output: optimal multivariate KM (M-KMO) p-value
}
\description{
This function (MKMO) is used to perform optimal KM analysis for quantitative traits in GWAS multivariate data.
}
\examples{
#######################################################################################
### Examples for Multivariate (two) Continuous Traits in GWAS Data using optimal KM ###
#######################################################################################
### Subject IDs are numeric ###
data("MKM_numID")
obj1 <- MKMO_Null_Model(phenotype=mkm_n_ph$y, trait=mkm_n_ph$trait, yid=mkm_n_ph$id,
covariates=NULL)
pvalue1 <- MKMO(obj=obj1, genotypes=mkm_n_gene, gid=mkm_n_geneid$gid, weights=NULL)
# Read in a list of genes files instead of a big file containing all genes
obj <- MKMO_Null_Model(phenotype=mkm_n_ph$y, trait=mkm_n_ph$trait, yid=mkm_n_ph$id,
covariates=NULL)
gene <- split(mkm_n_gene, mkm_n_gene[,1])
for (k in 1:2) {
  gene[[k]]$gene <- as.character(gene[[k]]$gene)
  pvalue1 <- MKMO(obj=obj, genotypes=gene[[k]], gid=mkm_n_geneid$gid, weights=NULL)
}
### Subject IDs are character ###
data("MKM_charID")
obj1 <- MKMO_Null_Model(phenotype=mkm_c_ph$y, trait=mkm_c_ph$trait,
yid=as.character(mkm_c_ph$id), covariates=NULL)
pvalue1 <- MKMO(obj=obj1, genotypes=mkm_c_gene, gid=as.character(mkm_c_geneid$gid),
weights=NULL)
}
