% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.KFS.R
\name{fitted.SSModel}
\alias{fitted.SSModel}
\alias{fitted.KFS}
\alias{fitted.SSModel}
\title{Smoothed Estimates or One-step-ahead Predictions of Fitted Values}
\usage{
\method{fitted}{KFS}(object, start = NULL, end = NULL, filtered = FALSE,
  ...)

\method{fitted}{SSModel}(object, start = NULL, end = NULL,
  filtered = FALSE, nsim = 0, ...)
}
\arguments{
\item{object}{An object of class \code{KFS} or \code{SSModel}.}

\item{start}{The start time of the period of interest. Defaults to first time
point of the object.}

\item{end}{The end time of the period of interest. Defaults to the last time
point of the object.}

\item{filtered}{Logical, return filtered instead of smoothed estimates of
state vector. Default is \code{FALSE}.}

\item{...}{Additional arguments to \code{\link{KFS}}.
Ignored in method for object of class \code{KFS}.}

\item{nsim}{Only for method for for non-Gaussian model of class \code{SSModel}.
The number of independent samples used in importance sampling.
Default is 0, which computes the
approximating Gaussian model by \code{\link{approxSSM}} and performs the
usual Gaussian filtering/smoothing so that the smoothed state estimates
equals to the conditional mode of \eqn{p(\alpha_t|y)}{p(\alpha[t]|y)}.
In case of \code{nsim = 0}, the mean estimates and their variances are computed using
the Delta method (ignoring the covariance terms).}
}
\value{
Multivariate time series containing fitted values.
}
\description{
Computes fitted values from output of \code{KFS}
(or using the \code{SSModel} object), i.e. one-step-ahead
predictions  \eqn{f(\theta_t | y_{t-1}, \ldots, y_1)}{
f(\theta[t] | y[t-1], ... , y[1]),} (\code{m}) or smoothed estimates
\eqn{f(\theta_t | y_n, \ldots, y_1)}{f(\theta[t] | y[n], ... , y[1]),} (\code{muhat}),
where \eqn{f} is the inverse of the link function
(identity in Gaussian case), except in case of Poisson distribution where
\eqn{f} is multiplied with the exposure \eqn{u_t}{u[t]}.
}
\examples{
data("sexratio")
model <- SSModel(Male ~ SSMtrend(1,Q = list(NA)),u = sexratio[, "Total"],
  data = sexratio, distribution = "binomial")
model <- fitSSM(model,inits = -15, method = "BFGS")$model
out <- KFS(model)
identical(drop(out$muhat), fitted(out))

fitted(model)
}
\seealso{
\code{\link{signal}} for partial signals and their covariances.
}
