/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.javaGD;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JPanel;
import org.rosuda.javaGD.GDContainer;
import org.rosuda.javaGD.GDObject;
import org.rosuda.javaGD.GDState;
import org.rosuda.javaGD.LocatorSync;

public class JGDPanel
extends JPanel
implements GDContainer,
MouseListener {
    Vector l;
    boolean listChanged;
    public static boolean forceAntiAliasing = true;
    GDState gs;
    Dimension lastSize;
    public int devNr = -1;
    Dimension prefSize;
    LocatorSync lsCallback = null;

    public JGDPanel(double d, double d2) {
        this((int)d, (int)d2);
    }

    public JGDPanel(int n, int n2) {
        super(true);
        this.setOpaque(true);
        this.setSize(n, n2);
        this.prefSize = new Dimension(n, n2);
        this.l = new Vector();
        this.gs = new GDState();
        this.gs.f = new Font(null, 0, 12);
        this.setSize(n, n2);
        this.lastSize = this.getSize();
        this.addMouseListener(this);
        this.setBackground(Color.white);
    }

    public GDState getGState() {
        return this.gs;
    }

    public void setDeviceNumber(int n) {
        this.devNr = n;
    }

    public int getDeviceNumber() {
        return this.devNr;
    }

    public void closeDisplay() {
    }

    public synchronized void cleanup() {
        this.reset();
        this.l = null;
    }

    public synchronized boolean prepareLocator(LocatorSync locatorSync) {
        if (this.lsCallback != null && this.lsCallback != locatorSync) {
            this.lsCallback.triggerAction(null);
        }
        this.lsCallback = locatorSync;
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.lsCallback != null) {
            double[] dArray = null;
            if ((mouseEvent.getModifiers() & 0x10) > 0 && (mouseEvent.getModifiers() & 0xC) == 0) {
                dArray = new double[]{mouseEvent.getX(), mouseEvent.getY()};
            }
            LocatorSync locatorSync = this.lsCallback;
            this.lsCallback = null;
            locatorSync.triggerAction(dArray);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void initRefresh() {
        try {
            Class<?> clazz = Class.forName("org.rosuda.JRI.Rengine");
            if (clazz == null) {
                System.out.println(">> can't find Rengine, automatic resizing disabled. [c=null]");
            } else {
                Method method = clazz.getMethod("getMainEngine", null);
                Object object = method.invoke(null, null);
                if (object != null) {
                    Class[] classArray = new Class[]{Class.forName("java.lang.String")};
                    method = clazz.getMethod("eval", classArray);
                    Object[] objectArray = new Object[]{"try(JavaGD:::.javaGD.resize(" + this.devNr + "),silent=TRUE)"};
                    method.invoke(object, objectArray);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(">> can't find Rengine, automatic resizing disabled. [x:" + exception.getMessage() + "]");
        }
    }

    public void syncDisplay(boolean bl) {
        this.repaint();
    }

    public synchronized Vector getGDOList() {
        return this.l;
    }

    public synchronized void add(GDObject gDObject) {
        this.l.add(gDObject);
        this.listChanged = true;
    }

    public synchronized void reset() {
        this.l.removeAllElements();
        this.listChanged = true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.prefSize);
    }

    public synchronized void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        if (!dimension.equals(this.lastSize)) {
            this.initRefresh();
            this.lastSize = dimension;
            return;
        }
        if (forceAntiAliasing) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int n = 0;
        int n2 = this.l.size();
        graphics.setFont(this.gs.f);
        graphics.setClip(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        while (n < n2) {
            GDObject gDObject = (GDObject)this.l.elementAt(n++);
            gDObject.paint(this, this.gs, graphics);
        }
    }
}

