/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Databases;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.omegahat.Environment.Databases.ObjectDatabase;
import org.omegahat.Environment.Databases.ZipNameFilter;

public class PersistentObjectDatabase
extends ObjectDatabase {
    public static String COMPRESS_EXTENSION = ".omgz";
    public static boolean Compressed = false;
    protected static final Integer readFromDisk = new Integer(-1);
    protected boolean compressed = false;
    protected URL url = null;
    protected File dir = null;
    protected FilenameFilter filter = null;

    public PersistentObjectDatabase(File file) {
        this(file, true);
    }

    public PersistentObjectDatabase(File file, boolean bl) {
        this(file, bl, Compressed);
    }

    public PersistentObjectDatabase(File file, boolean bl, boolean bl2) {
        super(file.toString());
        this.directory(file, bl);
        try {
            this.url = new URL("file://" + file.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl2) {
            this.filter = new ZipNameFilter();
        }
        this.synchronize(false);
    }

    public PersistentObjectDatabase(String string) {
        this(new File(string));
    }

    public File asFile(String string) {
        return new File(String.valueOf(String.valueOf(this.directory())) + "/" + string + (this.compressed ? COMPRESS_EXTENSION : ""));
    }

    public boolean assign(String string, Object object) throws Exception {
        super.assign(string, object);
        this.write(string, object);
        return true;
    }

    public File directory() {
        return this.dir;
    }

    public File directory(File file) {
        return this.directory(file, false);
    }

    public File directory(File file, boolean bl) {
        this.dir = file;
        if (this.dir != null && !this.dir.canRead()) {
            System.err.println("Creating directory " + this.directory());
            this.dir.mkdirs();
        }
        return this.directory();
    }

    public FilenameFilter filter() {
        return this.filter;
    }

    public FilenameFilter filter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
        return this.filter();
    }

    public Object get(String string) {
        Object object = super.get(string);
        if (object == readFromDisk) {
            object = this.read(string);
            super.put(string, object);
        }
        return object;
    }

    public String[] objects() {
        String[] stringArray;
        if (this.filter != null) {
            stringArray = this.directory().list(this.filter);
            int n = stringArray.length;
            int n2 = COMPRESS_EXTENSION.length();
            int n3 = 0;
            while (n3 < n) {
                stringArray[n3] = stringArray[n3].substring(0, stringArray[n3].length() - n2);
                ++n3;
            }
        } else {
            stringArray = this.directory().list();
        }
        return stringArray;
    }

    public String[] objects(boolean bl) {
        if (bl) {
            return super.objects();
        }
        return this.objects();
    }

    public Object read(String string) {
        Object object = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.asFile(string));
            InputStream inputStream = null;
            inputStream = this.compressed ? new GZIPInputStream(fileInputStream) : fileInputStream;
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            System.err.println("Problem reading " + string);
        }
        return object;
    }

    public int readEntries(File file) {
        return this.readEntries(file, this.filter);
    }

    public int readEntries(File file, FilenameFilter filenameFilter) {
        File file2 = new File(String.valueOf(file.toString()) + "/");
        String[] stringArray = filenameFilter != null ? file2.list(filenameFilter) : file2.list();
        if (stringArray == null) {
            return 0;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.read(stringArray[n]);
            ++n;
        }
        return stringArray.length;
    }

    public Object remove(String string) {
        Object object = super.remove(string);
        File file = this.asFile(string);
        try {
            if (file.exists() && file.canWrite()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    public int synchronize() {
        return this.synchronize(true);
    }

    public int synchronize(boolean bl) {
        String[] stringArray = this.objects(false);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (bl) {
                super.put(stringArray[n2], this.read(stringArray[n2]));
            } else if (!this.exists(stringArray[n2])) {
                super.put(stringArray[n2], readFromDisk);
            }
            ++n2;
        }
        return this.size();
    }

    public Object write(String string, Object object) {
        if (object instanceof Serializable) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.asFile(string));
                OutputStream outputStream = fileOutputStream;
                if (this.compressed) {
                    outputStream = new GZIPOutputStream(fileOutputStream);
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(object);
                outputStream.close();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                System.err.println("Can't write " + string + ": " + exception);
                return null;
            }
        } else {
            System.err.println(String.valueOf(string) + "(" + (object != null ? object.getClass().getName() : "null") + ") is not serializable.");
        }
        return object;
    }
}

