% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{jpn_climate_stations_tbl_df}
\alias{jpn_climate_stations_tbl_df}
\title{Climate Stations in Japan}
\format{
A tibble with 157 observations and 11 variables:
\describe{
  \item{region}{Geographical region where the station is located (character)}
  \item{pref}{Prefecture name (character)}
  \item{no}{Station number (character)}
  \item{station}{Station name (character)}
  \item{altitude}{Altitude of the station (character)}
  \item{latitude}{Latitude coordinate (character)}
  \item{longitude}{Longitude coordinate (character)}
  \item{NS}{Latitude direction, North or South (character)}
  \item{WE}{Longitude direction, West or East (character)}
  \item{yomi}{Station name in Japanese phonetic script (character)}
  \item{city}{City name (character)}
}
}
\source{
Data taken from the clidatajp package version 0.5.2
}
\usage{
data(jpn_climate_stations_tbl_df)
}
\description{
This dataset, jpn_climate_stations_tbl_df, is a tibble containing information about 157 climate observation stations
located across various regions and prefectures in Japan. It includes details such as station name, location,
altitude, coordinates, and city information.
}
\details{
The dataset name has been kept as 'jpn_climate_stations_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
JapanAPIs package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
in any way.
}
