% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{JacobiCpp}
\alias{JacobiCpp}
\title{The Jacobi Algorithm using Rcpp}
\usage{
JacobiCpp(x, only_values = FALSE, eps = 0)
}
\arguments{
\item{x}{A real symmetric matrix}

\item{only_values}{A logical value: do you want eigenvalues only?}

\item{eps}{an error tolerance. 0.0 implies \code{.Machine$double.eps} and
\code{sqrt(.Machine$double.eps)} if \code{only_values = TRUE
}}
}
\value{
a list of two components as for \code{base::eigen}
}
\description{
The Classical Jacobi Algorithm in Compiled Code
}
\details{
Eigenvalues and optionally, eigenvectore, of a real symmetric matrix using the
classical Jacobi algorithm, (Jacobi, 1854)
}
\examples{
V <- crossprod(matrix(1:25, 5))
JacobiCpp(V)
identical(JacobiCpp(V), JacobiR(V))
all.equal(JacobiCpp(V)$values, base::eigen(V)$values)
}

