## ---- include = FALSE----------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup---------------------------------------------------------------
library(JWileymisc)

## ------------------------------------------------------------------------

mtcars$cyl <- factor(mtcars$cyl)
m <- stats::lm(mpg ~ hp + cyl, data = mtcars)

mp <- modelPerformance(m)
print(mp)


## ------------------------------------------------------------------------

## Cohen's f^2 effect size
mp$Performance[, F2]


## ------------------------------------------------------------------------

mt <- modelTest(m)
print(mt)


## ------------------------------------------------------------------------

APAStyler(mt)


