% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/JRF.R
\name{JRF}
\alias{JRF}
\title{Joint Random Forest for the simultaneous estimation of multiple related networks}
\usage{
JRF(X, ntree, mtry,genes.name)
}
\arguments{
\item{X}{List object containing expression data for each class, \code{X=list(x_1,x_2, ... )} where \code{x_j} is a \code{(p x n_j)} matrix with rows corresponding to genes and columns to samples. Missing values are not allowed.}

\item{ntree}{numeric value: number of trees.}

\item{mtry}{numeric value: number of predictors to be sampled at each node.}

\item{genes.name}{vector containing genes name. The order needs to match the rows of \code{x_j}.}

}
\value{
A matrix with \code{I} rows and \code{C + 2} columns where \code{I} is the total number of gene-gene interactions and \code{C} is the number of classes. The first two columns contain gene names for each interaction while the remaining columns contain importance scores for different classes. 
}
\description{
Algorithm for the simultaneous estimation of multiple related networks. Some of the functions utilized are a modified version of functions contained in the R package randomForest (A. Liaw and M. Wiener, 2002). 
}
\examples{

 # --- Derive weighted networks via JRF
 
 nclasses=2               # number of data sets / classes
 n1<-n2<-20               # sample size for each data sets
 p<-5                   # number of variables (genes)
 genes.name<-paste("G",seq(1,p),sep="")   # genes name
 
   # --- Generate data sets
 
 data1<-matrix(rnorm(p*n1),p,n1)       # generate data1
 data2<-matrix(rnorm(p*n2),p,n1)       # generate data2
 
   # --- Standardize variables to mean 0 and variance 1
   
  data1 <- t(apply(data1, 1, function(x) { (x - mean(x)) / sd(x) } ))
  data2 <- t(apply(data2, 1, function(x) { (x - mean(x)) / sd(x) } ))

   # --- Run JRF and obtain importance score of interactions for each class
   
  out<-JRF(list(data1,data2),mtry=round(sqrt(p-1)),ntree=1000,genes.name)


}
\references{
Petralia, F., Song, WM., Tu, Z. and Wang, P., A New Method for Joint Network Analysis Reveals Common and Different Co-Expression Patterns Among Genes and Proteins in Breast Cancer, submitted

A. Liaw and M. Wiener (2002). Classification and Regression by randomForest. \emph{R News} \bold{2}, 18--22.
}
