/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.TxtTableLoader;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.toolkit.ExtensionFileFilter;
import org.rosuda.JGR.toolkit.FileSelector;

public class DataLoader
extends JFrame {
    private static String[][] extensions = new String[][]{{"rda", "rdata"}, {"robj"}, {"csv"}, {"txt"}, {"sav"}, {"xpt"}, {"dta"}, {"syd", "sys"}, {"arff"}, {"rec"}, {"mtp"}, {"s3"}};
    private static String[] extensionDescription = new String[]{"R (*.rda *.rdata)", "R dput() (*.robj)", "Comma seperated (*.csv)", "Text file (*.txt)", "SPSS (*.sav)", "SAS export (*.xpt)", "Stata (*.dta)", "Systat (*.sys *.syd)", "ARFF (*.arff)", "Epiinfo (*.rec)", "Minitab (*.mtp)", "S data dump (*.s3)"};

    public DataLoader() {
        Object object;
        FileSelector fileSelector = new FileSelector(this, "Load Data File", 0);
        if (fileSelector.isSwing()) {
            object = fileSelector.getJFileChooser();
            for (int i = 0; i < extensionDescription.length; ++i) {
                ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(extensionDescription[i], extensions[i]);
                ((JFileChooser)object).addChoosableFileFilter(extensionFileFilter);
            }
            ((JFileChooser)object).setFileFilter(((JFileChooser)object).getAcceptAllFileFilter());
        }
        fileSelector.setVisible(true);
        object = fileSelector.getDirectory() + fileSelector.getFile();
        this.loadData(fileSelector.getFile(), fileSelector.getDirectory());
    }

    public void loadData(String string, String string2) {
        String string3;
        String string4 = string3 = string.indexOf(".") <= 0 ? JGR.MAINRCONSOLE.getUniqueName(string) : JGR.MAINRCONSOLE.getUniqueName(string.substring(0, string.indexOf(".")));
        if (string.toLowerCase().endsWith(".rda") || string.toLowerCase().endsWith(".rdata")) {
            this.loadRdaFile(string, string2);
        } else if (string.toLowerCase().endsWith(".robj")) {
            this.loadDputFile(string, string2);
        } else if (string.toLowerCase().endsWith(".r")) {
            Editor editor = new Editor((string2 + string).replace('\\', '/'), true);
            editor.dispose();
        } else if (string.toLowerCase().endsWith(".txt") | string.toLowerCase().endsWith(".csv")) {
            this.loadTxtFile(string, string2);
        } else {
            RController.loadPackage("foreign");
            if (string.toLowerCase().endsWith(".sav")) {
                JGR.MAINRCONSOLE.execute(string3 + " <- as.data.frame(read.spss('" + (string2 + string).replace('\\', '/') + "'))", true);
            } else if (string.toLowerCase().endsWith(".xpt") | string.toLowerCase().endsWith(".xport")) {
                JGR.MAINRCONSOLE.execute(string3 + " <- read.xport('" + (string2 + string).replace('\\', '/') + "')", true);
            } else if (string.toLowerCase().endsWith(".dta")) {
                JGR.MAINRCONSOLE.execute(string3 + " <- read.dta('" + (string2 + string).replace('\\', '/') + "')", true);
            } else if (string.toLowerCase().endsWith(".arff")) {
                JGR.MAINRCONSOLE.execute(string3 + " <- read.arff('" + (string2 + string).replace('\\', '/') + "')", true);
            } else if (string.toLowerCase().endsWith(".rec")) {
                JGR.MAINRCONSOLE.execute(string3 + " <- read.epiinfo('" + (string2 + string).replace('\\', '/') + "')", true);
            } else if (string.toLowerCase().endsWith(".mtp")) {
                JGR.MAINRCONSOLE.execute(string3 + " <- as.data.frame(read.mtp('" + (string2 + string).replace('\\', '/') + "'))", true);
            } else if (string.toLowerCase().endsWith(".s3")) {
                JGR.MAINRCONSOLE.execute("data.restore('" + (string2 + string).replace('\\', '/') + "',print=TRUE)", true);
            } else if (string.toLowerCase().endsWith(".syd") || string.toLowerCase().endsWith(".sys")) {
                JGR.MAINRCONSOLE.execute(string3 + " <- read.systat('" + (string2 + string).replace('\\', '/') + "')", true);
            } else {
                this.loadTxtFile(string, string2);
            }
        }
    }

    public void loadRdaFile(String string, String string2) {
        String string3 = JGR.MAINRCONSOLE.getUniqueName("temp");
        String string4 = "print(load(\"" + (string2 + string).replace('\\', '/') + "\"))";
        JGR.R.eval("cat('The following data objects have been loaded:\\\n')", false);
        JGR.MAINRCONSOLE.execute(string4, true);
    }

    public void loadDputFile(String string, String string2) {
        String string3 = string.indexOf(".") <= 0 ? JGR.MAINRCONSOLE.getUniqueName(string) : JGR.MAINRCONSOLE.getUniqueName(string.substring(0, string.indexOf(".")));
        JGR.MAINRCONSOLE.execute(string3 + " <- dget('" + (string2 + string).replace('\\', '/') + "')", true);
    }

    public void loadTxtFile(String string, String string2) {
        TxtTableLoader.run(string2 + string);
    }
}

