% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers.R
\name{augment.irtree_fit}
\alias{augment.irtree_fit}
\title{Augment data with information from an irtree_fit object}
\usage{
\method{augment}{irtree_fit}(x = NULL, data = NULL, se.fit = TRUE, method = "EAP", ...)
}
\arguments{
\item{x}{object of class irtree_fit as returned from  \code{\link[=fit.irtree_model]{fit()}}.}

\item{data}{Optional data frame that is returned together with the predicted
values. Argument is not needed since the data are contained in the fitted
object.}

\item{se.fit}{Logical indicating whether standard errors for the fitted
values should be returned as well.}

\item{method}{This is passed to \code{\link[mirt:fscores]{mirt::fscores()}} or
\code{\link[TAM:IRT.factor.scores.tam.mml]{TAM:::IRT.factor.scores()}} (as argument
\code{type}) if applicable.}

\item{...}{Additional arguments passed to \code{\link[mirt:fscores]{mirt::fscores()}} or
\code{\link[TAM:IRT.factor.scores.tam.mml]{TAM:::IRT.factor.scores()}} if
applicable.}
}
\value{
Returns a \link[tibble:tibble-package]{tibble} with one row for each
observation and one (two) additional columns for each latent variable if
\code{se.fit = FALSE} (if \code{se.fit = TRUE}). The names of the new columns start
with \code{.fit} (and \code{.se.fit}).
}
\description{
Augment accepts a model object and a dataset and adds
information about each observation in the dataset, namely, predicted values
in the .fitted column. New columns always begin with a . prefix to avoid
overwriting columns in the original dataset.
}
\details{
Note that \code{method} is used only for objects returned from
\code{irtree_fit(engine = "mirt")}.
}
\examples{
data("jackson")
df1 <- jackson[1:234, paste0("C", 1:5)]
irtree_create_template(df1)
m1 <- "
IRT:
t BY C1@1, C2@1, C3@1, C4@1, C5@1;
Class:
GRM"
fit1 <- fit(irtree_model(m1), data = df1)

tidy(fit1, par_type = "difficulty")

glance(fit1)

augment(fit1)
}
\seealso{
\code{\link[generics:augment]{generics::augment()}}
}
