% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_issues.R
\name{logical_reducer}
\alias{logical_reducer}
\title{Compute assertion}
\usage{
logical_reducer(
  ...,
  orientation = c("vector-wise", "overall"),
  logic_gate = c("AND", "OR")
)
}
\arguments{
\item{...}{Boolean objects that will be reduced into a single Boolean}

\item{orientation}{a character string that is either \code{"vector-wise"}
(by default) if you want to compute the assertion element by element (is
\dots contains vector of same length) or \code{"overall"} if you want to
compute the assertion with all the element contained in \dots.}

\item{logic_gate}{the logic operator which will aggregate the
different assertion related to values: \code{"OR"} or \code{"AND"} (by
default).}
}
\value{
a Boolean vector of length 1 if \code{orientation} is
\code{"overall"} and of the same length as the elements contained in \dots
if \code{orientation} is \code{"vector-wise"}.
}
\description{
This function allows the user to summarise a set of booleans into a single
boolean via a logic gate.
}
\details{
Logic gates work with Booleans in the following way:\tabular{lll}{
   AND gate \tab TRUE \tab FALSE \cr
   TRUE \tab TRUE \tab FALSE \cr
   FALSE \tab FALSE \tab FALSE \cr
}
\tabular{lll}{
   OR gate \tab TRUE \tab FALSE \cr
   TRUE \tab TRUE \tab TRUE \cr
   FALSE \tab TRUE \tab FALSE \cr
}


If the argument \code{orientation} is \code{"overall"}, then all the element
of ... will be computed together with logic gate provided by the argument
\code{logic_gate}.

For example, the following call:
\preformatted{
logical_reducer(
    TRUE, FALSE, c(TRUE, TRUE, TRUE),
    logic_gate = "AND", orientation = "overall"
)
}
will be return \code{FALSE} because the second argument (in \dots) has the
value \code{FALSE} and with the logic gate AND, the results is \code{FALSE}.

On the other hand, if the argument \code{orientation} is \code{"vector-wise"}
then the element of \dots must have the same length and their first element
will be computed together then their second... and at the end their last
element will be computed together  with logic gate provided by the argument
\code{logic_gate}.

For example, the following call:
\preformatted{
logical_reducer(
    c(TRUE, TRUE, FALSE), c(FALSE, TRUE, FALSE),
    logic_gate = "OR", orientation = "vector-wise"
)
}
will be return \code{c(TRUE, TRUE, FALSE)} because the first argument (in
\dots) contains \code{c(TRUE, TRUE)} as first and second argument (so with
the logic gate OR, the result is \code{TRUE}) and the third value of all
element in \dots is \code{FALSE} so the result is \code{FALSE}.
}
\keyword{internal}
