% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordia.R
\name{concordia.plot}
\alias{concordia.plot}
\title{Concordia diagram}
\usage{
concordia.plot(x, limits = NULL, alpha = 0.05, wetherill = TRUE,
  show.numbers = FALSE, ellipse.col = rgb(0, 1, 0, 0.5),
  concordia.col = "darksalmon", dcu = TRUE)
}
\arguments{
\item{x}{an object of class \code{UPb}}

\item{limits}{age limits of the concordia line}

\item{alpha}{confidence cutoff for the error ellipses}

\item{wetherill}{boolean flag (FALSE for Tera-Wasserburg)}

\item{show.numbers}{boolean flag (TRUE to show grain numbers)}

\item{ellipse.col}{background colour of the error ellipses}

\item{concordia.col}{colour of the concordia line}

\item{dcu}{show decay constant uncertainty?}
}
\description{
Wetherill and Tera-Wasserburg concordia diagrams
}
\examples{
data(UPb)
concordia.plot(UPb)
}

