% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Irescale.R
\name{plotHistogramOverlayNormal}
\alias{plotHistogramOverlayNormal}
\title{Creates an overlay of the histogram of the data and the theorical normal distribution.}
\usage{
plotHistogramOverlayNormal(vec, stats, density = 30,
  main = "Histogram")
}
\arguments{
\item{vec}{the vector to plot.}

\item{stats}{the stats obtained from summaryVector.}

\item{density}{the number of bins for the histogram, The default value is 30.}

\item{main}{the title of the histogram, The default value is "Histogram".}
}
\description{
\code{plotHistogramOverlayNormal} Overlays the histogram and the theorical normal distribution.
}
\examples{
inputFileName<-system.file("testdata", "chen.csv", package="Irescale")
input<-loadFile(inputFileName)
distM<-calculateEuclideanDistance(input$data)
I<-calculateMoranI(distM = distM,varOfInterest = input$varOfInterest)
vI<-resamplingI(1000,distM, input$varOfInterest)
statsVI<-summaryVector(vI)
plotHistogramOverlayNormal(vI,statsVI)
}
