% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InteRD.R
\name{InteRD2}
\alias{InteRD2}
\title{The InteRD2 estimate}
\usage{
InteRD2(bulk.data,list_marker,cell_type_unique,comb_sampled,ave_est,ave_sd,
lambda_option,tol=0.0005)
}
\arguments{
\item{bulk.data}{The `ExpressionSet` object for a target bulk data.}

\item{list_marker}{A list of pre-specified marker genes corresponding to each cell type.}

\item{cell_type_unique}{A list of cell types. It should match the order in list.marker.}

\item{comb_sampled}{A pre-specified cell type proportions for the target bulk data, which could be obtained from reference-based deconvolution approach.}

\item{ave_est}{A pre-specified population-level cell type proportions, which could be obtained from single-cell RNA-seq and external expression data from different studies, species, or data types}

\item{ave_sd}{A pre-specified standard deviation for cell-type proportion estimation. The default is 1 for each cell type.}

\item{lambda_option}{A sequence of values for the tuning parameter.}

\item{tol}{A tolerance value for convergence. The default is 0.0005.}
}
\value{
A list containing estimated cell type proportions corresponding to each tuning value, named `est`; and a sequence of goodness-of-fit values corresponding to each tuning value, named `metrics`. The smaller the better.
}
\description{
This function provides a robust deconvolution framework to integrate information from scRNA-seq references,
marker genes, and prior biological knowledge.
}
\examples{
##read data
library(InteRD)
readRDSFromWeb<-function(ref) {readRDS(gzcon(url(ref)))}
urlremote<-"https://github.com/chencxxy28/Data/raw/main/data_InteRD/"
pseudo.seger<-readRDSFromWeb(paste0(urlremote,"pseudo.seger.rds"))
InteRD1<-readRDSFromWeb(paste0(urlremote,"InteRD1.rds"))
ave_est<-readRDSFromWeb(paste0(urlremote,"ave_est.rds"))
ave_sd<-readRDSFromWeb(paste0(urlremote,"ave_sd.rds"))
list_marker<-readRDSFromWeb(paste0(urlremote,"list_markerbaron20.rds"))
lambda_option<-0
cell_type_unique<-c("alpha","beta","delta","gamma")
lambda_option<-10e+05
InteRD2.output<-InteRD2(bulk.data=pseudo.seger,list_marker,cell_type_unique,
comb_sampled=InteRD1,ave_est,ave_sd,lambda_option=lambda_option,tol=0.01)
InteRD2<-InteRD.predict.prop(InteRD.output=InteRD2.output)

}
