% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Main.R
\name{ks_plot}
\alias{ks_plot}
\title{ks_plot}
\usage{
ks_plot(actuals, predictedScores)
}
\arguments{
\item{actuals}{The actual binary flags for the response variable. It can take a numeric vector containing values of either 1 or 0, where 1 represents the 'Good' or 'Events' while 0 represents 'Bad' or 'Non-Events'.}

\item{predictedScores}{The prediction probability scores for each observation. If your classification model gives the 1/0 predcitions, convert it to a numeric vector of 1's and 0's.}
}
\value{
The KS plot
}
\description{
Plot the cumulative percentage of responders (ones) captured by the model
}
\details{
Plot the cumulative percentage of responders (ones) captured by the model against the expected cumulative percentage of responders at random (i.e. had there been no model).
The greater the distance between the random and model cumulatives, the better is the predictive ability of the model to effectively capture the responders (ones).
}
\examples{
data('ActualsAndScores')
ks_plot(actuals=ActualsAndScores$Actuals, predictedScores=ActualsAndScores$PredictedScores)
}
\author{
Selva Prabhakaran \email{selva86@gmail.com}
}

