% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotPrevalence}
\alias{plotPrevalence}
\title{Plot prevalence results}
\usage{
plotPrevalence(
  result,
  x = "prevalence_start_date",
  y = "prevalence",
  ylim = c(0, NA),
  ribbon = FALSE,
  facet = NULL,
  colour = NULL,
  options = list()
)
}
\arguments{
\item{result}{Prevalence results}

\item{x}{Variable to plot on x axis}

\item{y}{Variable to plot on y axis. Options are: "prevalence",
"denominator_count", "outcome_count"}

\item{ylim}{Limits for the Y axis}

\item{ribbon}{If TRUE, the plot will join points using a ribbon}

\item{facet}{Variables to use for facets}

\item{colour}{Variables to use for colours}

\item{options}{A list of optional plot options. See optionsPlot() for the
default parameters.}
}
\value{
A ggplot with the prevalence results plotted
}
\description{
Plot prevalence results
}
\examples{
\donttest{
cdm <- mockIncidencePrevalence(sampleSize = 1000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator",
  cohortDateRange = c(as.Date("2014-01-01"), as.Date("2018-01-01"))
)
prev <- estimatePointPrevalence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
plotPrevalence(prev)
}
}
