/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.algo;

import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.Former;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix3D;
import cern.colt.matrix.tobject.ObjectFactory2D;
import cern.colt.matrix.tobject.algo.ObjectFormatter;

public class IntFormatter
extends AbstractFormatter {
    private static final long serialVersionUID = 1L;

    public IntFormatter() {
        this("%d");
    }

    public IntFormatter(String string) {
        this.setFormat(string);
        this.setAlignment("decimal");
    }

    protected String form(IntMatrix1D intMatrix1D, int n, Former former) {
        return former.form(intMatrix1D.get(n));
    }

    protected String form(AbstractMatrix1D abstractMatrix1D, int n, Former former) {
        return this.form((IntMatrix1D)abstractMatrix1D, n, former);
    }

    public String[][] format(IntMatrix2D intMatrix2D) {
        String[][] stringArray = new String[intMatrix2D.rows()][intMatrix2D.columns()];
        int n = intMatrix2D.rows();
        while (--n >= 0) {
            stringArray[n] = this.formatRow(intMatrix2D.viewRow(n));
        }
        return stringArray;
    }

    protected String[][] format(AbstractMatrix2D abstractMatrix2D) {
        return this.format((IntMatrix2D)abstractMatrix2D);
    }

    protected int indexOfDecimalPoint(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            n = string.lastIndexOf(101);
        }
        if (n < 0) {
            n = string.lastIndexOf(69);
        }
        if (n < 0) {
            n = string.length();
        }
        return n;
    }

    protected int lead(String string) {
        if (this.alignment.equals("decimal")) {
            return this.indexOfDecimalPoint(string);
        }
        return super.lead(string);
    }

    public String toSourceCode(IntMatrix1D intMatrix1D) {
        IntFormatter intFormatter = (IntFormatter)this.clone();
        intFormatter.setPrintShape(false);
        intFormatter.setColumnSeparator(", ");
        String string = "{";
        String string2 = "};";
        return string + intFormatter.toString(intMatrix1D) + string2;
    }

    public String toSourceCode(IntMatrix2D intMatrix2D) {
        IntFormatter intFormatter = (IntFormatter)this.clone();
        String string = this.blanks(3);
        intFormatter.setPrintShape(false);
        intFormatter.setColumnSeparator(", ");
        intFormatter.setRowSeparator("},\n" + string + "{");
        String string2 = "{\n" + string + "{";
        String string3 = "}\n};";
        return string2 + intFormatter.toString(intMatrix2D) + string3;
    }

    public String toSourceCode(IntMatrix3D intMatrix3D) {
        IntFormatter intFormatter = (IntFormatter)this.clone();
        String string = this.blanks(3);
        String string2 = this.blanks(6);
        intFormatter.setPrintShape(false);
        intFormatter.setColumnSeparator(", ");
        intFormatter.setRowSeparator("},\n" + string2 + "{");
        intFormatter.setSliceSeparator("}\n" + string + "},\n" + string + "{\n" + string2 + "{");
        String string3 = "{\n" + string + "{\n" + string2 + "{";
        String string4 = "}\n" + string + "}\n}";
        return string3 + intFormatter.toString(intMatrix3D) + string4;
    }

    public String toString(IntMatrix1D intMatrix1D) {
        IntMatrix2D intMatrix2D = intMatrix1D.like2D(1, (int)intMatrix1D.size());
        intMatrix2D.viewRow(0).assign(intMatrix1D);
        return this.toString(intMatrix2D);
    }

    public String toString(IntMatrix2D intMatrix2D) {
        return super.toString(intMatrix2D);
    }

    public String toString(IntMatrix3D intMatrix3D) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.printShape;
        this.printShape = false;
        for (int i = 0; i < intMatrix3D.slices(); ++i) {
            if (i != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toString(intMatrix3D.viewSlice(i)));
        }
        this.printShape = bl;
        if (this.printShape) {
            stringBuffer.insert(0, IntFormatter.shape(intMatrix3D) + "\n");
        }
        return stringBuffer.toString();
    }

    protected String toString(AbstractMatrix2D abstractMatrix2D) {
        return this.toString((IntMatrix2D)abstractMatrix2D);
    }

    protected String toTitleString(IntMatrix2D intMatrix2D, String[] stringArray, String[] stringArray2, String string, String string2, String string3) {
        if (intMatrix2D.size() == 0L) {
            return "Empty matrix";
        }
        Object[][] objectArray = this.format(intMatrix2D);
        this.align((String[][])objectArray);
        return new ObjectFormatter().toTitleString(ObjectFactory2D.dense.make(objectArray), stringArray, stringArray2, string, string2, string3);
    }

    private String xtoTitleString(IntMatrix3D intMatrix3D, String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String string2, String string3, String string4) {
        if (intMatrix3D.size() == 0L) {
            return "Empty matrix";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < intMatrix3D.slices(); ++i) {
            if (i != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toTitleString(intMatrix3D.viewSlice(i), stringArray2, stringArray3, string2, string3, string4 + "\n" + string + "=" + stringArray[i]));
        }
        return stringBuffer.toString();
    }
}

