/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseRCDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix2D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdcomplex.DComplexMult;
import cern.jet.math.tdcomplex.DComplexPlusMultFirst;
import cern.jet.math.tdcomplex.DComplexPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseCCDComplexMatrix2D
extends WrapperDComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] columnPointers;
    protected int[] rowIndexes;
    protected double[] values;

    public SparseCCDComplexMatrix2D(double[][] dArray) {
        this(dArray.length, dArray[0].length);
        this.assign(dArray);
    }

    public SparseCCDComplexMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseCCDComplexMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.rowIndexes = new int[n3];
        this.values = new double[2 * n3];
        this.columnPointers = new int[n2 + 1];
    }

    public SparseCCDComplexMatrix2D(int n, int n2, int[] nArray, int[] nArray2, double d, double d2, boolean bl) {
        int n3;
        block7: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (d == 0.0 && d2 == 0.0) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int n4 = Math.max(nArray.length, 1);
        this.rowIndexes = new int[n4];
        this.values = new double[2 * n4];
        this.columnPointers = new int[n2 + 1];
        int[] nArray3 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.columnPointers, nArray3, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.rowIndexes[var12_12] = nArray[n3];
            this.values[2 * var12_12] = d;
            this.values[2 * var12_12 + 1] = d2;
        }
        if (bl) {
            this.removeDuplicates();
        }
    }

    public SparseCCDComplexMatrix2D(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, boolean bl, boolean bl2) {
        int n3;
        block7: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (2 * nArray.length != dArray.length) {
            throw new IllegalArgumentException("2 * rowIndexes.length != values.length");
        }
        int n4 = Math.max(nArray.length, 1);
        this.rowIndexes = new int[n4];
        this.values = new double[2 * n4];
        this.columnPointers = new int[n2 + 1];
        int[] nArray3 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray3[n5] = nArray3[n5] + 1;
        }
        this.cumsum(this.columnPointers, nArray3, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray3[n6] = nArray3[n6] + 1;
            this.rowIndexes[var10_12] = nArray[n3];
            this.values[2 * var10_12] = dArray[2 * n3];
            this.values[2 * var10_12 + 1] = dArray[2 * n3 + 1];
        }
        if (bl) {
            this.removeDuplicates();
        }
    }

    public DComplexMatrix2D assign(final DComplexDComplexFunction dComplexDComplexFunction) {
        if (dComplexDComplexFunction instanceof DComplexMult) {
            double[] dArray = ((DComplexMult)dComplexDComplexFunction).multiplicator;
            if (dArray[0] == 1.0 && dArray[1] == 0.0) {
                return this;
            }
            if (dArray[0] == 0.0 && dArray[1] == 0.0) {
                return this.assign(0.0, 0.0);
            }
            if (dArray[0] != dArray[0] || dArray[1] != dArray[1]) {
                return this.assign(dArray);
            }
            double[] dArray2 = this.values;
            int n = this.cardinality();
            double[] dArray3 = new double[2];
            for (int i = 0; i < n; ++i) {
                dArray3[0] = dArray2[2 * i];
                dArray3[1] = dArray2[2 * i + 1];
                dArray3 = DComplex.mult(dArray3, dArray);
                dArray2[2 * i] = dArray3[0];
                dArray2[2 * i + 1] = dArray3[1];
            }
        } else {
            this.forEachNonZero(new IntIntDComplexFunction(){

                public double[] apply(int n, int n2, double[] dArray) {
                    return dComplexDComplexFunction.apply(dArray);
                }
            });
        }
        return this;
    }

    public DComplexMatrix2D assign(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            Arrays.fill(this.rowIndexes, 0);
            Arrays.fill(this.columnPointers, 0);
            Arrays.fill(this.values, 0.0);
        } else {
            int n = this.cardinality();
            for (int i = 0; i < n; ++i) {
                this.values[2 * i] = d;
                this.values[2 * i + 1] = d2;
            }
        }
        return this;
    }

    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D) {
        if (dComplexMatrix2D == this) {
            return this;
        }
        this.checkShape(dComplexMatrix2D);
        if (dComplexMatrix2D instanceof SparseCCDComplexMatrix2D) {
            SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D = (SparseCCDComplexMatrix2D)dComplexMatrix2D;
            System.arraycopy(sparseCCDComplexMatrix2D.getColumnPointers(), 0, this.columnPointers, 0, this.columns + 1);
            int n = sparseCCDComplexMatrix2D.getRowIndexes().length;
            if (this.rowIndexes.length < n) {
                this.rowIndexes = new int[n];
                this.values = new double[2 * n];
            }
            System.arraycopy(sparseCCDComplexMatrix2D.getRowIndexes(), 0, this.rowIndexes, 0, n);
            System.arraycopy(sparseCCDComplexMatrix2D.getValues(), 0, this.values, 0, sparseCCDComplexMatrix2D.getValues().length);
        } else if (dComplexMatrix2D instanceof SparseRCDComplexMatrix2D) {
            SparseRCDComplexMatrix2D sparseRCDComplexMatrix2D = ((SparseRCDComplexMatrix2D)dComplexMatrix2D).getConjugateTranspose();
            this.columnPointers = sparseRCDComplexMatrix2D.getRowPointers();
            this.rowIndexes = sparseRCDComplexMatrix2D.getColumnIndexes();
            this.values = sparseRCDComplexMatrix2D.getValues();
        } else {
            this.assign(0.0, 0.0);
            dComplexMatrix2D.forEachNonZero(new IntIntDComplexFunction(){

                public double[] apply(int n, int n2, double[] dArray) {
                    SparseCCDComplexMatrix2D.this.setQuick(n, n2, dArray);
                    return dArray;
                }
            });
        }
        return this;
    }

    public DComplexMatrix2D assign(DComplexMatrix2D dComplexMatrix2D, DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        this.checkShape(dComplexMatrix2D);
        if (dComplexMatrix2D instanceof SparseCCDComplexMatrix2D && dComplexDComplexDComplexFunction == DComplexFunctions.plus) {
            SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D = (SparseCCDComplexMatrix2D)dComplexMatrix2D;
            int n = 0;
            int n2 = this.rows;
            int n3 = this.columnPointers[this.columns];
            int n4 = sparseCCDComplexMatrix2D.columns;
            int[] nArray = sparseCCDComplexMatrix2D.columnPointers;
            int n5 = nArray[n4];
            int[] nArray2 = new int[n2];
            double[] dArray = new double[2 * n2];
            SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D2 = new SparseCCDComplexMatrix2D(n2, n4, n3 + n5);
            int[] nArray3 = sparseCCDComplexMatrix2D2.columnPointers;
            int[] nArray4 = sparseCCDComplexMatrix2D2.rowIndexes;
            double[] dArray2 = sparseCCDComplexMatrix2D2.values;
            double[] dArray3 = new double[]{1.0, 0.0};
            for (int i = 0; i < n4; ++i) {
                nArray3[i] = n;
                n = this.scatter(this, i, dArray3, nArray2, dArray, i + 1, sparseCCDComplexMatrix2D2, n);
                n = this.scatter(sparseCCDComplexMatrix2D, i, dArray3, nArray2, dArray, i + 1, sparseCCDComplexMatrix2D2, n);
                for (int j = nArray3[i]; j < n; ++j) {
                    dArray2[2 * j] = dArray[2 * nArray4[j]];
                    dArray2[2 * j + 1] = dArray[2 * nArray4[j] + 1];
                }
            }
            nArray3[n4] = n;
            this.rowIndexes = nArray4;
            this.columnPointers = nArray3;
            this.values = dArray2;
            return this;
        }
        if (dComplexDComplexDComplexFunction instanceof DComplexPlusMultSecond) {
            final double[] dArray = ((DComplexPlusMultSecond)dComplexDComplexDComplexFunction).multiplicator;
            if (dArray[0] == 0.0 && dArray[1] == 0.0) {
                return this;
            }
            dComplexMatrix2D.forEachNonZero(new IntIntDComplexFunction(){

                public double[] apply(int n, int n2, double[] dArray2) {
                    SparseCCDComplexMatrix2D.this.setQuick(n, n2, DComplex.plus(SparseCCDComplexMatrix2D.this.getQuick(n, n2), DComplex.mult(dArray, dArray2)));
                    return dArray2;
                }
            });
            return this;
        }
        if (dComplexDComplexDComplexFunction instanceof DComplexPlusMultFirst) {
            final double[] dArray = ((DComplexPlusMultFirst)dComplexDComplexDComplexFunction).multiplicator;
            if (dArray[0] == 0.0 && dArray[1] == 0.0) {
                return this.assign(dComplexMatrix2D);
            }
            dComplexMatrix2D.forEachNonZero(new IntIntDComplexFunction(){

                public double[] apply(int n, int n2, double[] dArray2) {
                    SparseCCDComplexMatrix2D.this.setQuick(n, n2, DComplex.plus(DComplex.mult(dArray, SparseCCDComplexMatrix2D.this.getQuick(n, n2)), dArray2));
                    return dArray2;
                }
            });
            return this;
        }
        if (dComplexDComplexDComplexFunction == DComplexFunctions.mult) {
            int[] nArray = this.rowIndexes;
            int[] nArray5 = this.columnPointers;
            double[] dArray = this.values;
            double[] dArray4 = new double[2];
            int n = this.columns;
            while (--n >= 0) {
                int n6 = nArray5[n];
                int n7 = nArray5[n + 1];
                while (--n7 >= n6) {
                    int n8 = nArray[n7];
                    dArray4[0] = dArray[2 * n7];
                    dArray4[1] = dArray[2 * n7 + 1];
                    dArray4 = DComplex.mult(dArray4, dComplexMatrix2D.getQuick(n8, n));
                    dArray[2 * n7] = dArray4[0];
                    dArray[2 * n7 + 1] = dArray4[1];
                    if (dArray[2 * n7] != 0.0 || dArray[2 * n7 + 1] != 0.0) continue;
                    this.remove(n8, n);
                }
            }
            return this;
        }
        if (dComplexDComplexDComplexFunction == DComplexFunctions.div) {
            int[] nArray = this.rowIndexes;
            int[] nArray6 = this.columnPointers;
            double[] dArray = this.values;
            double[] dArray5 = new double[2];
            int n = this.columns;
            while (--n >= 0) {
                int n9 = nArray6[n];
                int n10 = nArray6[n + 1];
                while (--n10 >= n9) {
                    int n11 = nArray[n10];
                    dArray5[0] = dArray[2 * n10];
                    dArray5[1] = dArray[2 * n10 + 1];
                    dArray5 = DComplex.div(dArray5, dComplexMatrix2D.getQuick(n11, n));
                    dArray[2 * n10] = dArray5[0];
                    dArray[2 * n10 + 1] = dArray5[1];
                    if (dArray[2 * n10] != 0.0 || dArray[2 * n10 + 1] != 0.0) continue;
                    this.remove(n11, n);
                }
            }
            return this;
        }
        return super.assign(dComplexMatrix2D, dComplexDComplexDComplexFunction);
    }

    public int cardinality() {
        return this.columnPointers[this.columns];
    }

    public DComplexMatrix2D forEachNonZero(IntIntDComplexFunction intIntDComplexFunction) {
        int[] nArray = this.rowIndexes;
        int[] nArray2 = this.columnPointers;
        double[] dArray = this.values;
        double[] dArray2 = new double[2];
        int n = this.columns;
        while (--n >= 0) {
            int n2 = nArray2[n];
            int n3 = nArray2[n + 1];
            while (--n3 >= n2) {
                int n4 = nArray[n3];
                dArray2[0] = dArray[2 * n3];
                dArray2[1] = dArray[2 * n3 + 1];
                dArray2 = intIntDComplexFunction.apply(n4, n, dArray2);
                dArray[2 * n3] = dArray2[0];
                dArray[2 * n3 + 1] = dArray2[1];
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.columnPointers;
    }

    public DenseDComplexMatrix2D getDense() {
        final DenseDComplexMatrix2D denseDComplexMatrix2D = new DenseDComplexMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntDComplexFunction(){

            public double[] apply(int n, int n2, double[] dArray) {
                denseDComplexMatrix2D.setQuick(n, n2, SparseCCDComplexMatrix2D.this.getQuick(n, n2));
                return dArray;
            }
        });
        return denseDComplexMatrix2D;
    }

    public synchronized double[] getQuick(int n, int n2) {
        int n3 = SparseCCDComplexMatrix2D.searchFromTo(this.rowIndexes, n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        double[] dArray = new double[2];
        if (n3 >= 0) {
            dArray[0] = this.values[2 * n3];
            dArray[1] = this.values[2 * n3 + 1];
        }
        return dArray;
    }

    public SparseRCDComplexMatrix2D getRowCompressed() {
        SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D = this.getConjugateTranspose();
        SparseRCDComplexMatrix2D sparseRCDComplexMatrix2D = new SparseRCDComplexMatrix2D(this.rows, this.columns);
        sparseRCDComplexMatrix2D.columnIndexes = sparseCCDComplexMatrix2D.rowIndexes;
        sparseRCDComplexMatrix2D.rowPointers = sparseCCDComplexMatrix2D.columnPointers;
        sparseRCDComplexMatrix2D.values = sparseCCDComplexMatrix2D.values;
        return sparseRCDComplexMatrix2D;
    }

    public int[] getRowIndexes() {
        return this.rowIndexes;
    }

    public SparseCCDComplexMatrix2D getConjugateTranspose() {
        int n;
        int n2 = this.rows;
        int n3 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        double[] dArray = this.values;
        SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D = new SparseCCDComplexMatrix2D(this.columns, this.rows, nArray2.length);
        int[] nArray3 = new int[n2];
        int[] nArray4 = sparseCCDComplexMatrix2D.columnPointers;
        int[] nArray5 = sparseCCDComplexMatrix2D.rowIndexes;
        double[] dArray2 = sparseCCDComplexMatrix2D.values;
        for (n = 0; n < nArray[n3]; ++n) {
            int n4 = nArray2[n];
            nArray3[n4] = nArray3[n4] + 1;
        }
        this.cumsum(nArray4, nArray3, n2);
        for (int i = 0; i < n3; ++i) {
            for (n = nArray[i]; n < nArray[i + 1]; ++n) {
                int n5 = nArray2[n];
                nArray3[n5] = nArray3[n5] + 1;
                nArray5[var2_13] = i;
                dArray2[2 * var2_13] = dArray[2 * n];
                dArray2[2 * var2_13 + 1] = -dArray[2 * n + 1];
            }
        }
        return sparseCCDComplexMatrix2D;
    }

    public double[] getValues() {
        return this.values;
    }

    public DComplexMatrix2D like(int n, int n2) {
        return new SparseCCDComplexMatrix2D(n, n2);
    }

    public DComplexMatrix1D like1D(int n) {
        return new SparseDComplexMatrix1D(n);
    }

    public synchronized void setQuick(int n, int n2, double[] dArray) {
        int n3 = SparseCCDComplexMatrix2D.searchFromTo(this.rowIndexes, n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        if (n3 >= 0) {
            if (dArray[0] == 0.0 && dArray[1] == 0.0) {
                this.remove(n2, n3);
            } else {
                this.values[2 * n3] = dArray[0];
                this.values[2 * n3 + 1] = dArray[1];
            }
            return;
        }
        if (dArray[0] != 0.0 || dArray[1] != 0.0) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, dArray);
        }
    }

    public synchronized void setQuick(int n, int n2, double d, double d2) {
        int n3 = SparseCCDComplexMatrix2D.searchFromTo(this.rowIndexes, n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        if (n3 >= 0) {
            if (d == 0.0 && d2 == 0.0) {
                this.remove(n2, n3);
            } else {
                this.values[2 * n3] = d;
                this.values[2 * n3 + 1] = d2;
            }
            return;
        }
        if (d != 0.0 || d2 != 0.0) {
            n3 = -n3 - 1;
            this.insert(n, n2, n3, d, d2);
        }
    }

    public void sortRowIndexes() {
        SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D = this.getConjugateTranspose();
        sparseCCDComplexMatrix2D = sparseCCDComplexMatrix2D.getConjugateTranspose();
        this.columnPointers = sparseCCDComplexMatrix2D.columnPointers;
        this.rowIndexes = sparseCCDComplexMatrix2D.rowIndexes;
        this.values = sparseCCDComplexMatrix2D.values;
    }

    public void removeDuplicates() {
        int n;
        int n2 = 0;
        int n3 = this.rows;
        int n4 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        double[] dArray = this.values;
        int[] nArray3 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray3[n] = -1;
        }
        for (int i = 0; i < n4; ++i) {
            int n5 = n2;
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                n = nArray2[j];
                if (nArray3[n] >= n5) {
                    int n6 = nArray3[n];
                    dArray[n6] = dArray[n6] + dArray[j];
                    continue;
                }
                nArray3[n] = n2;
                nArray2[n2] = n;
                dArray[2 * n2] = dArray[2 * j];
                dArray[2 * n2 + 1] = dArray[2 * j + 1];
                ++n2;
            }
            nArray[i] = n5;
        }
        nArray[n4] = n2;
    }

    public void removeZeroes() {
        int n = 0;
        int n2 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        double[] dArray = this.values;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                if (dArray[j] == 0.0) continue;
                nArray2[n] = nArray2[j];
                dArray[2 * n] = dArray[2 * j];
                dArray[2 * n + 1] = dArray[2 * j + 1];
                ++n;
            }
        }
        nArray[n2] = n;
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.columns; ++i) {
            int n = this.columnPointers[i + 1];
            for (int j = this.columnPointers[i]; j < n; ++j) {
                if (this.values[2 * j + 1] > 0.0) {
                    stringBuilder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[2 * j]).append('+').append(this.values[2 * j + 1]).append('i').append('\n');
                    continue;
                }
                if (this.values[2 * j + 1] == 0.0) {
                    stringBuilder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[2 * j]).append('\n');
                    continue;
                }
                stringBuilder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[2 * j]).append('-').append(this.values[2 * j + 1]).append('i').append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public DComplexMatrix1D zMult(DComplexMatrix1D dComplexMatrix1D, DComplexMatrix1D dComplexMatrix1D2, final double[] dArray, final double[] dArray2, boolean bl) {
        boolean bl2;
        int n = bl ? this.columns : this.rows;
        int n2 = bl ? this.rows : this.columns;
        boolean bl3 = bl2 = dComplexMatrix1D2 == null || bl;
        if (dComplexMatrix1D2 == null) {
            dComplexMatrix1D2 = new DenseDComplexMatrix1D(n);
        }
        if (!(dComplexMatrix1D instanceof DenseDComplexMatrix1D) || !(dComplexMatrix1D2 instanceof DenseDComplexMatrix1D)) {
            return super.zMult(dComplexMatrix1D, dComplexMatrix1D2, dArray, dArray2, bl);
        }
        if ((long)n2 != dComplexMatrix1D.size() || (long)n > dComplexMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + dComplexMatrix1D.toStringShort() + ", " + dComplexMatrix1D2.toStringShort());
        }
        DenseDComplexMatrix1D denseDComplexMatrix1D = (DenseDComplexMatrix1D)dComplexMatrix1D2;
        final double[] dArray3 = denseDComplexMatrix1D.elements;
        final int n3 = denseDComplexMatrix1D.stride();
        final int n4 = (int)denseDComplexMatrix1D.index(0);
        DenseDComplexMatrix1D denseDComplexMatrix1D2 = (DenseDComplexMatrix1D)dComplexMatrix1D;
        final double[] dArray4 = denseDComplexMatrix1D2.elements;
        final int n5 = denseDComplexMatrix1D2.stride();
        final int n6 = (int)denseDComplexMatrix1D2.index(0);
        final int[] nArray = this.rowIndexes;
        final int[] nArray2 = this.columnPointers;
        final double[] dArray5 = this.values;
        int n7 = n4;
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (!bl) {
            if (!(bl2 || dArray2[0] == 1.0 && dArray2[1] == 0.0)) {
                dComplexMatrix1D2.assign(DComplexFunctions.mult(dArray2));
            }
            if (n8 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n9;
                n8 = 2;
                Future[] futureArray = new Future[n8];
                final double[] dArray6 = new double[2 * n];
                int n10 = this.columns / n8;
                for (n9 = 0; n9 < n8; ++n9) {
                    final int n11 = n9 * n10;
                    final int n12 = n9 == n8 - 1 ? this.columns : n11 + n10;
                    final int n13 = n9;
                    futureArray[n9] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            double[] dArray7 = new double[2];
                            double[] dArray2 = new double[2];
                            if (n13 == 0) {
                                for (int i = n11; i < n12; ++i) {
                                    int n = nArray2[i + 1];
                                    dArray7[0] = dArray4[n6 + n5 * i];
                                    dArray7[1] = dArray4[n6 + n5 * i + 1];
                                    for (int j = nArray2[i]; j < n; ++j) {
                                        int n2 = nArray[j];
                                        dArray2[0] = dArray5[2 * j];
                                        dArray2[1] = dArray5[2 * j + 1];
                                        dArray2 = DComplex.mult(dArray2, dArray7);
                                        dArray2 = DComplex.mult(dArray2, dArray);
                                        int n32 = n4 + n3 * n2;
                                        dArray3[n32] = dArray3[n32] + dArray2[0];
                                        int n42 = n4 + n3 * n2 + 1;
                                        dArray3[n42] = dArray3[n42] + dArray2[1];
                                    }
                                }
                            } else {
                                for (int i = n11; i < n12; ++i) {
                                    int n = nArray2[i + 1];
                                    dArray7[0] = dArray4[n6 + n5 * i];
                                    dArray7[1] = dArray4[n6 + n5 * i + 1];
                                    for (int j = nArray2[i]; j < n; ++j) {
                                        int n52 = nArray[j];
                                        dArray2[0] = dArray5[2 * j];
                                        dArray2[1] = dArray5[2 * j + 1];
                                        dArray2 = DComplex.mult(dArray2, dArray7);
                                        dArray2 = DComplex.mult(dArray2, dArray);
                                        int n62 = 2 * n52;
                                        dArray6[n62] = dArray6[n62] + dArray2[0];
                                        int n7 = 2 * n52 + 1;
                                        dArray6[n7] = dArray6[n7] + dArray2[1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n9 = 0; n9 < n; ++n9) {
                    int n14 = n4 + n9 * n3;
                    dArray3[n14] = dArray3[n14] + dArray6[2 * n9];
                    int n15 = n4 + n9 * n3 + 1;
                    dArray3[n15] = dArray3[n15] + dArray6[2 * n9 + 1];
                }
            } else {
                double[] dArray7 = new double[2];
                double[] dArray8 = new double[2];
                for (int i = 0; i < this.columns; ++i) {
                    int n16 = nArray2[i + 1];
                    dArray7[0] = dArray4[n6 + n5 * i];
                    dArray7[1] = dArray4[n6 + n5 * i + 1];
                    for (int j = nArray2[i]; j < n16; ++j) {
                        int n17 = nArray[j];
                        dArray8[0] = dArray5[2 * j];
                        dArray8[1] = dArray5[2 * j + 1];
                        dArray8 = DComplex.mult(dArray8, dArray7);
                        dArray8 = DComplex.mult(dArray8, dArray);
                        int n18 = n4 + n3 * n17;
                        dArray3[n18] = dArray3[n18] + dArray8[0];
                        int n19 = n4 + n3 * n17 + 1;
                        dArray3[n19] = dArray3[n19] + dArray8[1];
                    }
                }
            }
        } else if (n8 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n8];
            int n20 = this.columns / n8;
            for (int i = 0; i < n8; ++i) {
                final int n21 = i * n20;
                final int n22 = i == n8 - 1 ? this.columns : n21 + n20;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n4 + n21 * n3;
                        double[] dArray6 = new double[2];
                        double[] dArray22 = new double[2];
                        double[] dArray32 = new double[2];
                        for (int i = n21; i < n22; ++i) {
                            double[] dArray42 = new double[2];
                            int n2 = SparseCCDComplexMatrix2D.this.columnPointers[i + 1];
                            for (int j = SparseCCDComplexMatrix2D.this.columnPointers[i]; j < n2; ++j) {
                                dArray6[0] = dArray5[2 * j];
                                dArray6[1] = -dArray5[2 * j + 1];
                                dArray22[0] = dArray4[n6 + n5 * SparseCCDComplexMatrix2D.this.rowIndexes[j]];
                                dArray22[1] = dArray4[n6 + n5 * SparseCCDComplexMatrix2D.this.rowIndexes[j] + 1];
                                dArray42 = DComplex.plus(dArray42, DComplex.mult(dArray6, dArray22));
                            }
                            dArray42 = DComplex.mult(dArray, dArray42);
                            dArray32[0] = dArray3[n];
                            dArray32[1] = dArray3[n + 1];
                            dArray32 = DComplex.mult(dArray32, dArray2);
                            dArray3[n] = dArray42[0] + dArray32[0];
                            dArray3[n + 1] = dArray42[1] + dArray32[1];
                            n += n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray9 = new double[2];
            double[] dArray10 = new double[2];
            double[] dArray11 = new double[2];
            for (int i = 0; i < this.columns; ++i) {
                double[] dArray12 = new double[2];
                int n23 = this.columnPointers[i + 1];
                for (int j = this.columnPointers[i]; j < n23; ++j) {
                    dArray9[0] = dArray5[2 * j];
                    dArray9[1] = -dArray5[2 * j + 1];
                    dArray10[0] = dArray4[n6 + n5 * this.rowIndexes[j]];
                    dArray10[1] = dArray4[n6 + n5 * this.rowIndexes[j] + 1];
                    dArray12 = DComplex.plus(dArray12, DComplex.mult(dArray9, dArray10));
                }
                dArray12 = DComplex.mult(dArray, dArray12);
                dArray11[0] = dArray3[n7];
                dArray11[1] = dArray3[n7 + 1];
                dArray11 = DComplex.mult(dArray11, dArray2);
                dArray3[n7] = dArray12[0] + dArray11[0];
                dArray3[n7 + 1] = dArray12[1] + dArray11[1];
                n7 += n3;
            }
        }
        return dComplexMatrix1D2;
    }

    public DComplexMatrix2D zMult(DComplexMatrix2D dComplexMatrix2D, DComplexMatrix2D dComplexMatrix2D2, double[] dArray, double[] dArray2, boolean bl, boolean bl2) {
        boolean bl3;
        int n = this.rows;
        int n2 = this.columns;
        if (bl) {
            n = this.columns;
            n2 = this.rows;
        }
        int n3 = dComplexMatrix2D.rows();
        int n4 = dComplexMatrix2D.columns();
        if (bl2) {
            n3 = dComplexMatrix2D.columns();
            n4 = dComplexMatrix2D.rows();
        }
        int n5 = n4;
        boolean bl4 = bl3 = dComplexMatrix2D2 == null;
        if (dComplexMatrix2D2 == null) {
            dComplexMatrix2D2 = dComplexMatrix2D instanceof SparseCCDComplexMatrix2D ? new SparseCCDComplexMatrix2D(n, n5, n * n5) : new DenseDComplexMatrix2D(n, n5);
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? dComplexMatrix2D.viewDice() : dComplexMatrix2D).toStringShort());
        }
        if (dComplexMatrix2D2.rows() != n || dComplexMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? dComplexMatrix2D.viewDice() : dComplexMatrix2D).toStringShort() + ", " + dComplexMatrix2D2.toStringShort());
        }
        if (this == dComplexMatrix2D2 || dComplexMatrix2D == dComplexMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!(bl3 || dArray2[0] == 1.0 && dArray2[1] == 0.0)) {
            dComplexMatrix2D2.assign(DComplexFunctions.mult(dArray2));
        }
        if (dComplexMatrix2D instanceof DenseDComplexMatrix2D && dComplexMatrix2D2 instanceof DenseDComplexMatrix2D) {
            SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D = bl ? this.getConjugateTranspose() : this;
            DenseDComplexMatrix2D denseDComplexMatrix2D = bl2 ? (DenseDComplexMatrix2D)dComplexMatrix2D.getConjugateTranspose() : (DenseDComplexMatrix2D)dComplexMatrix2D;
            DenseDComplexMatrix2D denseDComplexMatrix2D2 = (DenseDComplexMatrix2D)dComplexMatrix2D2;
            int[] nArray = sparseCCDComplexMatrix2D.columnPointers;
            int[] nArray2 = sparseCCDComplexMatrix2D.rowIndexes;
            double[] dArray3 = sparseCCDComplexMatrix2D.values;
            int n6 = (int)denseDComplexMatrix2D.index(0, 0);
            int n7 = denseDComplexMatrix2D.rowStride();
            int n8 = denseDComplexMatrix2D.columnStride();
            double[] dArray4 = denseDComplexMatrix2D.elements;
            int n9 = (int)denseDComplexMatrix2D2.index(0, 0);
            int n10 = denseDComplexMatrix2D2.rowStride();
            int n11 = denseDComplexMatrix2D2.columnStride();
            double[] dArray5 = denseDComplexMatrix2D2.elements;
            double[] dArray6 = new double[2];
            double[] dArray7 = new double[2];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n12 = nArray[j + 1];
                    dArray7[0] = dArray4[n6 + j * n7 + i * n8];
                    dArray7[1] = dArray4[n6 + j * n7 + i * n8 + 1];
                    for (int k = nArray[j]; k < n12; ++k) {
                        int n13 = nArray2[k];
                        dArray6[0] = dArray3[2 * k];
                        dArray6[1] = dArray3[2 * k + 1];
                        dArray6 = DComplex.mult(dArray6, dArray7);
                        int n14 = n9 + n13 * n10 + i * n11;
                        dArray5[n14] = dArray5[n14] + dArray6[0];
                        int n15 = n9 + n13 * n10 + i * n11 + 1;
                        dArray5[n15] = dArray5[n15] + dArray6[1];
                    }
                }
            }
            if (dArray[0] != 1.0 || dArray[1] != 0.0) {
                dComplexMatrix2D2.assign(DComplexFunctions.mult(dArray));
            }
        } else if (dComplexMatrix2D instanceof SparseCCDComplexMatrix2D && dComplexMatrix2D2 instanceof SparseCCDComplexMatrix2D) {
            SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D = bl ? this.getConjugateTranspose() : this;
            SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D2 = (SparseCCDComplexMatrix2D)dComplexMatrix2D;
            if (bl2) {
                sparseCCDComplexMatrix2D2 = sparseCCDComplexMatrix2D2.getConjugateTranspose();
            }
            SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D3 = (SparseCCDComplexMatrix2D)dComplexMatrix2D2;
            int n16 = 0;
            int n17 = n;
            int n18 = n4;
            int[] nArray = sparseCCDComplexMatrix2D2.columnPointers;
            int[] nArray3 = sparseCCDComplexMatrix2D2.rowIndexes;
            double[] dArray8 = sparseCCDComplexMatrix2D2.values;
            int[] nArray4 = new int[n17];
            double[] dArray9 = new double[2 * n17];
            int[] nArray5 = sparseCCDComplexMatrix2D3.columnPointers;
            Object[] objectArray = sparseCCDComplexMatrix2D3.rowIndexes;
            double[] dArray10 = sparseCCDComplexMatrix2D3.values;
            for (int i = 0; i < n18; ++i) {
                Object[] objectArray2;
                int n19 = sparseCCDComplexMatrix2D3.rowIndexes.length;
                if (n16 + n17 > n19) {
                    n19 = 2 * n19 + n17;
                    objectArray2 = new int[n19];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    double[] dArray11 = new double[2 * n19];
                    System.arraycopy(dArray10, 0, dArray11, 0, dArray10.length);
                    dArray10 = dArray11;
                }
                nArray5[i] = n16;
                objectArray2 = new double[2];
                for (n5 = nArray[i]; n5 < nArray[i + 1]; ++n5) {
                    objectArray2[0] = dArray8[2 * n5];
                    objectArray2[1] = dArray8[2 * n5 + 1];
                    n16 = this.scatter(sparseCCDComplexMatrix2D, nArray3[n5], (double[])objectArray2, nArray4, dArray9, i + 1, sparseCCDComplexMatrix2D3, n16);
                }
                for (n5 = nArray5[i]; n5 < n16; ++n5) {
                    dArray10[2 * n5] = dArray9[2 * objectArray[n5]];
                    dArray10[2 * n5 + 1] = dArray9[2 * objectArray[n5] + 1];
                }
            }
            nArray5[n18] = n16;
            if (dArray[0] != 1.0 || dArray[1] != 0.0) {
                sparseCCDComplexMatrix2D3.assign(DComplexFunctions.mult(dArray));
            }
        } else {
            if (bl2) {
                dComplexMatrix2D = dComplexMatrix2D.getConjugateTranspose();
            }
            DComplexMatrix1D[] dComplexMatrix1DArray = new DComplexMatrix1D[n2];
            int n20 = n2;
            while (--n20 >= 0) {
                dComplexMatrix1DArray[n20] = dComplexMatrix2D.viewRow(n20);
            }
            DComplexMatrix1D[] dComplexMatrix1DArray2 = new DComplexMatrix1D[n];
            int n21 = n;
            while (--n21 >= 0) {
                dComplexMatrix1DArray2[n21] = dComplexMatrix2D2.viewRow(n21);
            }
            DComplexPlusMultSecond dComplexPlusMultSecond = DComplexPlusMultSecond.plusMult(new double[2]);
            int[] nArray = this.rowIndexes;
            int[] nArray6 = this.columnPointers;
            double[] dArray12 = this.values;
            double[] dArray13 = new double[2];
            int n22 = this.columns;
            while (--n22 >= 0) {
                int n23 = nArray6[n22];
                int n24 = nArray6[n22 + 1];
                while (--n24 >= n23) {
                    int n25 = nArray[n24];
                    dArray13[0] = dArray12[2 * n24];
                    dArray13[1] = dArray12[2 * n24 + 1];
                    dComplexPlusMultSecond.multiplicator = DComplex.mult(dArray13, dArray);
                    if (!bl) {
                        dComplexMatrix1DArray2[n25].assign(dComplexMatrix1DArray[n22], dComplexPlusMultSecond);
                        continue;
                    }
                    dComplexMatrix1DArray2[n22].assign(dComplexMatrix1DArray[n25], dComplexPlusMultSecond);
                }
            }
        }
        return dComplexMatrix2D2;
    }

    protected DComplexMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, double[] dArray) {
        IntArrayList intArrayList = new IntArrayList(this.rowIndexes);
        intArrayList.setSizeRaw(this.columnPointers[this.columns]);
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.values);
        doubleArrayList.setSizeRaw(2 * this.columnPointers[this.columns]);
        intArrayList.beforeInsert(n3, n);
        doubleArrayList.beforeInsert(2 * n3, dArray[0]);
        doubleArrayList.beforeInsert(2 * n3 + 1, dArray[1]);
        int n4 = this.columnPointers.length;
        while (--n4 > n2) {
            int n5 = n4;
            this.columnPointers[n5] = this.columnPointers[n5] + 1;
        }
        this.rowIndexes = intArrayList.elements();
        this.values = doubleArrayList.elements();
    }

    protected void insert(int n, int n2, int n3, double d, double d2) {
        IntArrayList intArrayList = new IntArrayList(this.rowIndexes);
        intArrayList.setSizeRaw(this.columnPointers[this.columns]);
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.values);
        doubleArrayList.setSizeRaw(2 * this.columnPointers[this.columns]);
        intArrayList.beforeInsert(n3, n);
        doubleArrayList.beforeInsert(2 * n3, d);
        doubleArrayList.beforeInsert(2 * n3 + 1, d2);
        int n4 = this.columnPointers.length;
        while (--n4 > n2) {
            int n5 = n4;
            this.columnPointers[n5] = this.columnPointers[n5] + 1;
        }
        this.rowIndexes = intArrayList.elements();
        this.values = doubleArrayList.elements();
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.rowIndexes);
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.values);
        intArrayList.remove(n2);
        doubleArrayList.remove(2 * n2);
        doubleArrayList.remove(2 * n2 + 1);
        int n3 = this.columnPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.columnPointers[n4] = this.columnPointers[n4] - 1;
        }
        this.rowIndexes = intArrayList.elements();
        this.values = doubleArrayList.elements();
    }

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }

    private long cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            l += (long)nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return l;
    }

    private void realloc(int n) {
        if (n <= 0) {
            n = this.columnPointers[this.columns];
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.rowIndexes.length);
        System.arraycopy(this.rowIndexes, 0, nArray, 0, n2);
        this.rowIndexes = nArray;
        double[] dArray = new double[2 * n];
        n2 = Math.min(n, this.values.length);
        System.arraycopy(this.values, 0, dArray, 0, n2);
        this.values = dArray;
    }

    private int scatter(SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D, int n, double[] dArray, int[] nArray, double[] dArray2, int n2, SparseCCDComplexMatrix2D sparseCCDComplexMatrix2D2, int n3) {
        int[] nArray2 = sparseCCDComplexMatrix2D.columnPointers;
        int[] nArray3 = sparseCCDComplexMatrix2D.rowIndexes;
        double[] dArray3 = sparseCCDComplexMatrix2D.values;
        int[] nArray4 = sparseCCDComplexMatrix2D2.rowIndexes;
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        for (int i = nArray2[n]; i < nArray2[n + 1]; ++i) {
            int n4 = nArray3[i];
            if (nArray[n4] < n2) {
                nArray[n4] = n2;
                nArray4[n3++] = n4;
                if (dArray2 == null) continue;
                dArray5[0] = dArray3[2 * i];
                dArray5[1] = dArray3[2 * i + 1];
                dArray5 = DComplex.mult(dArray, dArray5);
                dArray2[2 * n4] = dArray5[0];
                dArray2[2 * n4 + 1] = dArray5[1];
                continue;
            }
            if (dArray2 == null) continue;
            dArray5[0] = dArray3[2 * i];
            dArray5[1] = dArray3[2 * i + 1];
            dArray5 = DComplex.mult(dArray, dArray5);
            int n5 = 2 * n4;
            dArray2[n5] = dArray2[n5] + dArray5[0];
            int n6 = 2 * n4 + 1;
            dArray2[n6] = dArray2[n6] + dArray5[1];
        }
        return n3;
    }
}

