% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imp_gamlss_fit.R
\name{ImpGamlssFit}
\alias{ImpGamlssFit}
\title{GAMLSS imputation fit}
\usage{
ImpGamlssFit(data, new.data, family, n.ind.par, lin.terms, forceNormal,
  trace = FALSE, ...)
}
\arguments{
\item{data}{Completely observed data frame to be used to fit a
gamlss model estimate.}

\item{new.data}{Data frame used to predict the parameter values for
some given right side x-values on the gamlss model.}

\item{family}{Family to be used for the response variable on the
GAMLSS estimation.}

\item{n.ind.par}{Number of individual parameters to be
fitted. Currently it only allows one or two because of stability
issues for more parameters.}

\item{lin.terms}{Character vector specifying which (if any)
predictor variables should enter the model linearly.}

\item{forceNormal}{Flag that if set to 'TRUE' will use a normal
family for the gamlss estimation as a last resource.}

\item{trace}{whether to print at each iteration (TRUE) or not (FALSE)}

\item{...}{extra arguments for the control of the gamlss fitting
function}
}
\value{
Returns a method to generate random samples for the fitted
  gamlss model using "new.data" as covariates.
}
\description{
This function takes uses a data set to fit a gamlss model and
another to predict the expected parameters values. It returns a
function that will generate a vector of ramdom observations for the
predicted parameters. The amount of random obervations is the
number of units on the dataset used to get such predictions.
}

