% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITNcorr_function.R
\name{ITNcorr}
\alias{ITNcorr}
\title{ITN Correlation Plot}
\usage{
ITNcorr(gs)
}
\arguments{
\item{gs}{International Trade Network - igraph object}
}
\value{
Correlation plot
}
\description{
This function plots the correlation between degree and strength scores
}
\examples{
require(igraph)
##Create random International Trade Network (igraph object)
ITN<-erdos.renyi.game(75,0.05,directed = TRUE)

##Add edge weights
E(ITN)$weight<-runif(ecount(ITN), 0, 1)

##Plot correlation matrix between degree and strength scores.
corr_plot<-ITNcorr(ITN)

}
