##' @title Get ggplot2 Grapic observed versus estimated of Total
##' @description this function displays/saves/returns a Graphical ggplot2 illustrating the difference between the observed and estimated
##' @param titulo is the title graphic
##' @param nome name of file case save
##' @param observado list containing the observations of variable
##' @param estimado list containing estimates of variable
##' @param identificadorIndividual list containing 'id' of individuals
##' @param identificadorGrupal list containing group of individuals
##' @param showTestF draw results of test F in graphic?
##' @param TestFposition show one of the four corners of the graph clockwise
##' @param titleIdentificadorGrupal title of Legend of the groups
##' @param save If you want to save enter the directory as a string
##' @param labsX label x
##' @param labsy label y
##' @param nomeParaExibir This is the name to display the graph as a function after the completion of this
##' @param environ environment in which the function to display the ggplot2 must be saved
##' @param extensao type of image that will be saved
##' @param desc description of plot geted from avaliavolumeavancado
##' @param data database to retireve fields to id
##' @param mapeamento name of fields on base
##' @param ... only for compatibility with other functions
##' @return will be returned the graphical generated by ggplot2
##' @import ggplot2
##' @export
getggplot2GraphicObservadoXEstimadoTotal <- function (
  titulo = "observadoXestimado",
  nome = "observadoXestimado",
  observado,
  estimado,
  identificadorIndividual = NULL,
  identificadorGrupal = NULL,
  showTestF = TRUE,
  TestFposition = 4,
  titleIdentificadorGrupal = NULL,
  save = NULL,
  labsX = "observado",
  labsy = "estimado",
  nomeParaExibir = NULL,
  environ = 1,
  extensao = ".png",
  desc = NULL,
  data = NULL,
  mapeamento = list(idade2 = "idadearred2", parcela = "parcela", areacorr = "areacorr"),
  ...)
{
  tipo = strsplit(desc, '\\.')[[1]][[3]]
  labsX = eval(parse(text = paste('expression(paste("', tipo, ' estimado ", m^3, " ", ha^-1))')))
  labsy = eval(parse(text = paste('expression(paste("', tipo, ' ", m^3, " ", ha^-1))')))

  data$observado = observado
  data$estimado = estimado
  data$idade = data[, mapeamento$idade2]

  df = sqldf(paste("SELECT ", mapeamento$parcela, " AS parcela, idade, SUM(observado) AS volumeTotal2, SUM(estimado) AS volumeTotal2EstMAI, ", mapeamento$areacorr, " AS areacorr FROM data GROUP By ", mapeamento$parcela, ", idade"))
  df$volumeTotal2HA = (10000/df$areacorr) * df$volumeTotal2
  df$volumeTotal2EstMAIHA = (10000/df$areacorr) * df$volumeTotal2EstMAI

  graphic = ggplot(data = NULL, aes( df$volumeTotal2HA , df$volumeTotal2EstMAIHA ))
  if (!is.null(identificadorIndividual) && !is.null(identificadorGrupal)) {
    graphic <- ggplot(data = NULL, aes( df$volumeTotal2HA , df$volumeTotal2EstMAIHA,
                                       colour = as.factor(identificadorIndividual), size = unclass(as.factor(identificadorGrupal))))
  }
  else if (!is.null(identificadorIndividual)) {
    graphic <- ggplot(data = NULL, aes( df$volumeTotal2HA , df$volumeTotal2EstMAIHA,
                                       colour = as.factor(identificadorIndividual)))
  }
  else if (!is.null(identificadorGrupal)) {
    graphic <- ggplot(data = NULL, aes( df$volumeTotal2HA , df$volumeTotal2EstMAIHA,
                                       colour = as.factor(identificadorGrupal)))
  }
  graphic = graphic + guides(color = FALSE) + geom_point() +
    geom_abline() + stat_smooth(fill = "blue", colour = "darkblue",
                                size = 2) + labs(x = labsX, y = labsy, title = paste(titulo, " total por ", mapeamento$parcela))
  if (is.null(titleIdentificadorGrupal))
    graphic = graphic + guides(size = FALSE)
  else graphic = graphic + labs(size = titleIdentificadorGrupal)
  if (showTestF == TRUE) {
    coeficientes = lm(df$volumeTotal2EstMAIHA ~ df$volumeTotal2HA)
    X = min(observado)
    Y = max(estimado)
    hj = 0
    vj = 1
    if (TestFposition == 1) {
      X = max(observado)
      Y = max(estimado)
      hj = 1
      vj = 1
    }
    if (TestFposition == 2) {
      X = max(observado)
      Y = min(estimado)
      hj = 1
      vj = 0
    }
    if (TestFposition == 3) {
      X = min(observado)
      Y = min(estimado)
      hj = 0
      vj = 0
    }
    graphic = graphic + annotate("text", colour = "blue",
                                 x = X, y = Y, label = paste("atop(atop( bold(Teste~~paste(F,':')), atop(paste(beta,0) == ",
                                                             round(coeficientes$coefficients[1], digits = 3),
                                                             ", paste(beta,1) == ", round(coeficientes$coefficients[2],
                                                                                          digits = 3), ")),\n                                          paste(bold(over('    ','   ')), over('    ','   '),bold( over('    ','   ')), ' tendency line'))"),
                                 parse = T, hjust = hj, vjust = vj)
  }
  if (!is.null(save)) {
    ggsave(paste0(save, "total por ", mapeamento$parcela, " ",  nome, " ObservadoxEstimado", extensao), plot = graphic)
  }
  if (!is.null(nomeParaExibir)) {
    eval(parse(text = paste0("assign(\"", nomeParaExibir,
                             "\", graphic, envir = as.environment(environ))")))
    print(paste0("use ", nomeParaExibir, " para exibir o ggplot2"))
  }
  return(graphic)
}
