% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{iscamsummary}
\alias{iscamsummary}
\title{Some Summary Statistics}
\usage{
iscamsummary(x, explanatory = NULL, digits = 3)
}
\arguments{
\item{x}{data to summarize.}

\item{explanatory}{optional explanatory variable to group by.}

\item{digits}{number of digits to round to.}
}
\value{
A table with some summary statistics of \code{x}.
}
\description{
\code{summary} calculates the five number summary, mean, and standard
deviation of the quantitative variable \code{x}. An optional second, categorical
variable can be specified and values will be calculated separately for
each group. The number of digits in output can also be specified. Skewness is
sample skewness: \eqn{g_1 := \frac{m_3}{m_2^{3/2}}}, where
\eqn{m_2 := \frac{1}{n}\sum_{i=1}^{n}(x_i - \bar{x})^2}
and \eqn{m_3 := \frac{1}{n}\sum_{i=1}^{n}(x_i - \bar{x})^3} are the second
and third central sample moments.
}
\examples{
set.seed(0)
fake_data <- rnorm(30) # simulating some data
groups <- sample(c("group1","group2"), 30, TRUE)
iscamsummary(fake_data)
iscamsummary(fake_data, explanatory = groups, digits = 2) # with groups
}
