## README
The `IRexamples` R package contains example code for analyzing data or accomplishing tasks relevant to institutional or educational researchers.

## Install Package
```R
# From CRAN
install.packages('IRexamples')

# From github (Development)
devtools::install_github('vinhdizzo/IRexamples')
```

## Vignettes and Tutorials
The following are vignettes/tutorials included in the package:

1. [Propensity Score Weights Using Gradient Boosted Trees](https://CRAN.R-project.org/package=IRexamples/vignettes/Ex-01-Propensity-Score-Weights-Using-GBM.html).
2. [Adjusting for Survey Non-Response Using Weights](https://CRAN.R-project.org/package=IRexamples/vignettes/Ex-02-Adjusting-For-Survey-Non-Response-Using-Weights.html).
3. [Accounting for Instructor-level Effects with Bayesian Multilevel Models](https://CRAN.R-project.org/package=IRexamples/vignettes/Ex-03-Instructor-Level-Effects-With-Bayesian-Multilevel-Models.html).
4. [Webscraping Online Data Files](https://CRAN.R-project.org/package=IRexamples/vignettes/Ex-04-Webscraping-Online-Data-Files.html).
5. [Example 5: Geocoding Addresses and Spatial Applications](https://CRAN.R-project.org/package=IRexamples/vignettes/Ex-05-Geocoding-Addresses.html)
