% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IOHanalyzer.R
\docType{package}
\name{IOHanalyzer}
\alias{IOHanalyzer}
\title{IOHanalyzer: Data Analysis Part of IOHprofiler}
\description{
The data analysis module for the Iterative Optimization Heuristics Profiler (IOHprofiler).
This module provides statistical analysis methods for the benchmark data generated by
optimization heuristics, which can be visualized through a
web-based interface. The benchmark data is usually generated by the
experimentation module, called IOHexperimenter. IOHanalyzer also supports
the widely used COCO (Comparing Continuous Optimisers) data format for benchmarking.
}
\section{Functions}{

The IOHanalyzer consists of 3 main functionalities:
\itemize{
\item Reading and alligning data from different heuristics, such as IOHExperimenter.
This is done using the \code{\link{DataSet}} and \code{\link{DataSetList}} functions
\item Processing and summarizing this data
\item Creating various plots
}
}

\examples{
path <- system.file("extdata", "ONE_PLUS_LAMDA_EA", package="IOHanalyzer")
dsList <- DataSetList(path)
summary(dsList)
Plot.RT.Single_Func(dsList[1])

\dontrun{
runServer()
}
}
