% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{get_dsc_posthoc}
\alias{get_dsc_posthoc}
\title{Perform post-hoc processing on data from DSCtool}
\usage{
get_dsc_posthoc(omni_res, nr_algs, nr_problems, base_algorithm = NULL,
  method = "friedman", alpha = 0.05)
}
\arguments{
\item{omni_res}{The result from a call to `get_dsc_omnibus`}

\item{nr_algs}{The number of algorithms present in `omni_res`}

\item{nr_problems}{The number of problems present in `omni_res`}

\item{base_algorithm}{The base algorithm to which the other are compared. 
This has to be present in `omni_res$algorithm_means` as an `algorithm` property}

\item{method}{Either 'friedman' or 'friedman-aligned-rank'}

\item{alpha}{Threshold value for statistical significance}
}
\value{
A named list containing 4 types of analyses:
* Zvalue
* UnadjustedPValue
* Holm
* Hochberg
}
\description{
Perform post-hoc processing on data from DSCtool
}
\examples{
get_dsc_posthoc(get_dsc_omnibus(get_dsc_rank(dsl)), 2, 2)
}
