% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INLAvaan-package.R
\docType{package}
\name{INLAvaan-package}
\alias{INLAvaan-package}
\alias{INLAvaan}
\title{INLAvaan: Approximate Bayesian Latent Variable Analysis}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Implements approximate Bayesian inference for Structural Equation Models (SEM) using a custom adaptation of the Integrated Nested Laplace Approximation as described in Rue et al. (2009) \doi{10.1111/j.1467-9868.2008.00700.x}. Provides a computationally efficient alternative to Markov Chain Monte Carlo (MCMC) for Bayesian estimation, allowing users to fit latent variable models using the 'lavaan' syntax.
}
\section{Main features}{

\itemize{
\item \code{\link[=acfa]{acfa()}}: Approximate Confirmatory Factor Analysis.
\item \code{\link[=asem]{asem()}}: Approximate Structural Equation Modelling.
\item \code{\link[=agrowth]{agrowth()}}: Approximate Latent Growth Curve models.
}
}

\section{Model specifications}{

Supports advanced 'lavaan' syntax features, including:
\itemize{
\item Equality constraints
\item Defined parameters (e.g., \verb{:=} operator for indirect effects)
\item Flexible prior specifications
}
}

\section{Online vignettes}{

The \href{https://inlavaan.haziqj.ml/}{package website} contains comprehensive examples covering:
\itemize{
\item Confirmatory Factor Analysis (CFA)
\item Structural Equation Models (SEM)
\item Latent Growth Curve Models
\item Multigroup and Invariance Testing
\item Mediation Analysis
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://inlavaan.haziqj.ml/}
  \item \url{https://github.com/haziqj/INLAvaan}
  \item Report bugs at \url{https://github.com/haziqj/INLAvaan/issues}
}

}
\author{
\strong{Maintainer}: Haziq Jamil \email{haziq.jamil@gmail.com} (\href{https://orcid.org/0000-0003-3298-1010}{ORCID}) [copyright holder]

Other contributors:
\itemize{
  \item Håvard Rue (\href{https://orcid.org/0000-0002-0222-1881}{ORCID}) (Statistical and computational methodology) [contributor]
  \item Alvin Bong (Initial site build) [contributor]
}

}
\keyword{internal}
