% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INLAstep.R
\name{INLAstep}
\alias{INLAstep}
\title{Perform stepwise variable selection with INLA}
\usage{
INLAstep(fam1 = "gaussian", dataf, spde = NULL, in_stack = NULL,
  invariant = "0 + Intercept", direction = c("forwards", "backwards"),
  y = NULL, y2 = NULL, include = NULL, powerl = 1, inter = 1,
  thresh = 2, num.threads = 1, ...)
}
\arguments{
\item{fam1}{String defining the likelihood familiy.}

\item{dataf}{A dataframe including covariates and response data.}

\item{spde}{An spde model object for the spatial component.}

\item{in_stack}{An inla.data.stack object containing all needed data.}

\item{invariant}{The part of the formula that should not change (e.g. the intercept and the spatial component.)}

\item{direction}{string 'forwards' for forward variable selection and 'backwards' for backwards variable elimination.}

\item{y}{String determining the response variable.}

\item{y2}{String determining the name of the test response data.}

\item{include}{Vector of integers to determine which columns in dataf should be used. If NULL, use all columns except y and y2.}

\item{powerl}{Integer up to 3 determining which power terms to include.}

\item{inter}{Integer up to 3 determining how many levels of intereactions to include.}

\item{thresh}{Threshold difference in DIC for whether a new model should replace the old model.}

\item{num.threads}{How many threads to use for INLA computation.}

\item{...}{Further arguments to \code{INLA::inla} function.}
}
\description{
Run forwards or backwards stepwise variable selection with INLA regression.
Only fixed effects will be considered  for removal.
Use holdout data or within sample data to test new models.
Choose the level of interactions and power terms to expand the model formula to.
Force part of the model to remain in the model (e.g. the spatial term and intercept).
}
\examples{
\dontrun{
  library(INLA)
  data(Epil)
  stack <- INLA::inla.stack(data = list(y = Epil$y),
                           A = list(1),
                           effects = list(data.frame(Intercept = 1, Epil[3:5])))
                      
 
  result <- INLAstep(fam1 = "poisson", 
                     Epil,
                     in_stack = stack,
                     invariant = "0 + Intercept",
                     direction = 'backwards',
                     include = 3:5,
                     y = 'y',
                     y2 = 'y',
                     powerl = 1,
                     inter = 1,
                     thresh = 2)

  autoplot(result$best_model, which = c(1, 5), CI = TRUE)
}
}
