% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{model_selection_component}
\alias{model_selection_component}
\title{Component Selection}
\usage{
model_selection_component(
  data_input,
  data_type = c("p", "z"),
  tol = 1e-06,
  maxiter = 1000,
  seed = 10,
  verbose = FALSE
)
}
\arguments{
\item{data_input}{An n x d data frame or matrix of the summary statistics z score or p value, n is the nubmer of genes, d is the number of data types. Each row is a gene, each column is a data type.}

\item{data_type}{Whether the input data is the p values or z scores, default is p value}

\item{tol}{The convergence criterion. Convergence is declared when the change in the observed data log-likelihood increases by less than epsilon.}

\item{maxiter}{The maximum number of iteration, default is 1000}

\item{seed}{set.seed, default is 10}

\item{verbose}{Whether to print the full log-likelihood for each iteration, default is FALSE}
}
\value{
Selected number of components based on AIC and BIC
\item{Component_Selected_AIC}{Selected number of components by AIC with the smallest AIC value among all components and models}
\item{Component_Selected_BIC}{Selected number of components by BIC with the smallest BIC value among all components and models}
\item{AIC/BIC}{The AIC and BIC values for all components for IMIX_ind_unrestrict, IMIX_cor_twostep, and IMIX_cor}
\item{IMIX_ind_unrestrict}{A list of the IMIX_ind_unrestrict for all components 1,2,...2^d, this step was fitted using R package "Mclust", more details of the output can be found there}
\item{IMIX_cor_twostep}{A list of the IMIX_cor_twostep for all components 1,2,...2^d, here, the mean is the estimated value of IMIX_ind_unrestrict}
\item{IMIX_cor}{A list of the IMIX_cor_twostep for all components 1,2,...2^d}
}
\description{
Model selection for components based on AIC and BIC values for models in IMIX
}
\examples{
# A toy example
data("data_p")
set.seed(10)
data <- data_p[sample(1:1000,20,replace = FALSE),]
select_comp0 <- model_selection_component(data, data_type = "p", seed = 20)

\donttest{
# First load the data
data("data_p")

# Perform model selections on the data
select_comp1 = model_selection_component(data_p, data_type = "p", seed = 20)
}
}
\references{
Ziqiao Wang and Peng Wei. 2020. “IMIX: a multivariate mixture model approach to association analysis through multi-omics data integration.” Bioinformatics. \url{https://doi.org/10.1093/bioinformatics/btaa1001}.
Luca Scrucca, Michael Fop, T. Brendan Murphy, and Adrian E. Raftery. 2016. “mclust 5: Clustering, Classification and Density Estimation Using Gaussian Finite Mixture Models.” The R Journal 8 (1): 289–317. \url{https://doi.org/10.32614/RJ-2016-021}.
}
