% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullConditionals.R
\name{psi_hyper}
\alias{psi_hyper}
\title{Find sensible inverse gamma hyperparameters for variance/uniqueness parameters}
\usage{
psi_hyper(shape, covar, type = c("unconstrained", "isotropic"))
}
\arguments{
\item{shape}{A positive shape hyperparameter.}

\item{covar}{A square, positive-semidefinite covariance matrix.}

\item{type}{A switch indicating whether a single rate (\code{isotropic}) or variable-specific rates (\code{unconstrained}) are to be derived. The isotropic constraint provides the link between factor analysis and the probabilistic principal components analysis model. Uniquenesses are only allowed to be variable specific under the factor analysis model.}
}
\value{
Either a single rate hyperparameter or \code{ncol(covar)} variable specific hyperparameters.
}
\description{
Takes a shape hyperparameter and covariance matrix, and finds data-driven rate hyperparameters in such a way that Heywood problems are avoided for factor analysis or probabilistic principal components analysis (and mixtures thereof). Rates are allowed to be variable-specific or a single value under the factor analysis model, but must be a single value for the PPCA model. Used internally by \code{\link{mcmc_IMIFA}} when its argument \code{psi_beta} is not supplied.
}
\examples{
data(olive)
olive2 <- olive[,-(1:2)]
rates  <- psi_hyper(shape=2.5, covar=cov(olive2), type="isotropic")
rates

olive_scaled <- scale(olive2, center=TRUE, scale=TRUE)
rate   <- psi_hyper(shape=3, covar=cov(olive_scaled), type="unconstrained")
rate
}
\references{
Fruwirth-Schnatter, S. and Lopes, H. F. (2010). Parsimonious Bayesian factor analysis when the number of factors is unknown, \emph{Technical Report}. The University of Chicago Booth School of Business.

Tipping, M. E. and Bishop, C. M. (1999). Probabilistic principal component analysis, \emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}, 61(3): 611-622.
}
\seealso{
\code{\link{mcmc_IMIFA}}
}
\author{
Keefe Murphy
}
