% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlottingFunctions.R
\name{plot.Results_IMIFA}
\alias{plot.Results_IMIFA}
\title{Plotting output and parameters of inferential interest for IMIFA and related models}
\usage{
\method{plot}{Results_IMIFA}(x = NULL, plot.meth = c("all", "correlation",
  "density", "errors", "GQ", "means", "parallel.coords", "trace", "zlabels"),
  param = c("means", "scores", "loadings", "uniquenesses", "pis", "alpha"),
  zlabels = NULL, load.meth = c("heatmap", "raw"), palette = NULL,
  g = NULL, mat = TRUE, ind = NULL, fac = NULL, by.fac = TRUE,
  type = c("h", "n", "p", "l"), intervals = TRUE, partial = FALSE,
  titles = TRUE, transparency = 0.75, ...)
}
\arguments{
\item{x}{An object of class "\code{Results_IMIFA}" generated by \code{\link{get_IMIFA_results}}.}

\item{plot.meth}{The type of plot to be produced for the \code{param} of interest, where \code{correlation} refers to ACF/PACF plots, \code{means} refers to posterior means, \code{density}, \code{trace} and \code{parallel.coords} are self-explanatory. "\code{all}" in this case, the default, refers to {\code{trace, density, means, correlation}}. \code{parallel.coords} is only available when \code{param} is one of \code{means}, \code{loadings} or \code{uniquenesses} - note that this method applies a small amount of horizontal jitter to avoid overplotting. Special types of plots which don't require a \code{param} are \code{GQ}, for plotting the posterior summaries of the numbers of groups/factors, if available, \code{zlabels} for plotting clustering uncertainties if clustering has taken place (with or without the clustering labels being supplied via the \code{zlabels} argument), and \code{errors} for visualing the difference between the estimated and empirical covariance matrix/matrices.}

\item{param}{The parameter of interest for any of the following \code{plot.meth} options: {\code{trace, density, means, correlation}}. The \code{param} must have been stored when \code{\link{mcmc_IMIFA}} was initially ran. Includes \code{pis} for methods where clustering takes place, and allows posterior inference on \code{alpha} for the "\code{IMFA}" and "\code{IMIFA}" methods.}

\item{zlabels}{The true labels can be supplied if they are known. Only relevant when \code{plot.meth = "zlabels"}. If this is not supplied, the function uses the labels that were supplied, if any, to \code{\link{get_IMIFA_results}}.}

\item{load.meth}{Switch which allows plotting posterior mean loadings as a heatmap (the default), or as something akin to \code{link{plot}} with \code{type = "h"}. ONly relevant if \code{param = "loadings"}. Heatmaps are produced with the aid of \code{\link{mat2cols}} and \code{\link[gclus]{plotcolors}}.}

\item{palette}{An optional colour palette to be supplied if overwriting the default palette set inside the function by \code{\link[viridis]{viridis}} is desired.}

\item{g}{Optional argument that allows specification of exactly which cluster the plot of interest is to be produced for. If not supplied, the user will be prompted to cycle through plots for all clusters.}

\item{mat}{Logical indicating whether a \code{\link{matplot}} is produced (defaults to TRUE). If given as FALSE, \code{ind} is invoked.}

\item{ind}{Either a single number indicating which variable to plot when \code{param} is one of \code{means} or \code{uniquenesses}, or which cluster to plot if \code{param} is \code{pis}. If \code{scores} are plotted, a vector of length two giving which observation and factor to plot; If \code{loadings} are plotted, a vector of length two giving which variable and factor to plot. Only relevant when \code{mat} is FALSE.}

\item{fac}{Optional argument that provides an alternative way to specify \code{ind[2]} when \code{mat} is FALSE and \code{param} is one of \code{scores} or \code{loadings}.}

\item{by.fac}{Optionally allows (mat)plotting of scores and loadings by factor - i.e. observation(s) (scores) or variable(s) (loadings) for a given factor, respectively, controlled by \code{ind} or \code{fac}) when set to TRUE (the default). Otherwise factor(s) are plotted for a given observation or variable, again controlled by \code{ind} or \code{fac}.}

\item{type}{The manner in which the plot is to be drawn, as per the \code{type} argument to \code{\link{plot}}.}

\item{intervals}{Logical indicating whether credible intervals around the posterior mean(s) are to be plotted when \code{is.element(plot.meth, c("all", "means"))}. Defaults to TRUE.}

\item{partial}{Logical indicating whether plots of type "\code{correlation}" use the PACF. The default, FALSE, ensures the ACF is used. Only relevant when \code{plot.meth = "all"}, otherwise both plots are produced when \code{plot.meth = "correlation"}.}

\item{titles}{Logical indicating whether default plot titles are to be used (TRUE), or suppressed (FALSE).}

\item{transparency}{A factor in [0, 1] modifying the opacity for overplotted lines. Defaults to 0.75.}

\item{...}{Other arguments typically passed to \code{\link{plot}}.}
}
\value{
The desired plot with appropriate output and summary statistics printed to the console screen.
}
\description{
Plotting output and parameters of inferential interest for IMIFA and related models
}
\examples{
# See the vignette associated with the package for more graphical examples.

# data(olive)
# area     <- olive$area
# simIMIFA <- mcmc_IMIFA(olive, method="IMIFA")
# resIMIFA <- get_IMIFA_results(simIMIFA)

# plot(resIMIFA, "GQ")
# plot(resIMIFA, "GQ", g=2)

# plot(resIMIFA, "zlabels", zlabels=area)

# plot(resIMIFA, "errors")

# plot(resIMIFA, "all", "means", g=1)
# plot(resIMIFA, "all", "means", g=1, ind=2)
# plot(resIMIFA, "all", "scores")
# plot(resIMIFA, "all", "scores", by.fac=FALSE)
# plot(resIMIFA, "all", "loadings", g=1)
# plot(resIMIFA, "all", "loadings", g=1, load.meth="raw")
# plot(resIMIFA, "parallel.coords", "uniquenesses")
# plot(resIMIFA, "all", "pis", intervals=FALSE, partial=TRUE)
# plot(resIMIFA, "all", "alpha")
}
\references{
Murphy, K., Gormley, I.C. and Viroli, C. (2017) Infinite Mixtures of Infinite Factor Analysers: Nonparametric Model-Based Clustering via Latent Gaussian Models, \code{https://arxiv.org/abs/1701.07010}
}
\seealso{
\code{\link{mcmc_IMIFA}}, \code{\link{get_IMIFA_results}}, \code{\link{mat2cols}}, \code{\link[gclus]{plotcolors}}
}

