% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SolutionSource.R
\name{SolutionSource}
\alias{SolutionSource}
\title{Obtaining indexes associated with the solution sources.}
\usage{
SolutionSource(SolutionData,Production,EffectivenessOfSolution,Id,Verbose=TRUE)
}
\arguments{
\item{SolutionData}{It is an matrix object containing data from Solution sources.}

\item{Production}{Matrix with a column containing the damage or defoliation data.}

\item{EffectivenessOfSolution}{Output generated by the function  `EffectivenessOfSolution`}

\item{Id}{Logical vector indicating the lines of the `EffectivenessOfSolution` that are relevant.
Output generated by the function SelectEffectivenessOfSolution}

\item{Verbose}{Logical value (TRUE/FALSE). TRUE displays the results of the analysis.}
}
\value{
The function returns indices associated with the source of loss.
}
\description{
Function to estimate the total n of the S.S. (n), E.S., ks, c, ds, n.I.I.,
Sum.n.I.I., and percentage of I.I. (P.I.I.) by each S.S..
}
\examples{
data("DataLossSource")
ChisqTest_Distribution(DataLossSource)

data("DataSolutionSource")
ChisqTest_Distribution(DataSolutionSource)

data("DataDefoliation")
data("DataDamage")

DataResult<-cbind(DataDefoliation,DataDamage$D.L.S.2,DataDefoliation,
DataDamage$D.L.S.4,DataDefoliation)
ResultLossSource<-LossSource(DataLoss = DataLossSource,DataResult =DataResult,
Cols=c(1,3,5),verbose=TRUE)

EOS<-EffectivenessOfSolution(DataLossSource =DataLossSource,
                            DataSolutionSource =DataSolutionSource,
                            ResultLossSource = ResultLossSource)

EOS
#Put: y and y
# ID<-SelectEffectivenessOfSolution(EOS)
ID<-c(FALSE,FALSE,FALSE,TRUE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,
FALSE,FALSE,FALSE,TRUE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE)
ResultSolutionSource<-SolutionSource(SolutionData =DataSolutionSource,Production =DataResult,
                                    EffectivenessOfSolution =EOS ,Id = ID,Verbose = TRUE  )
ResultSolutionSource

# Put: y,n,y,n,y,n and y
# ReductionAbundance(ResultSolutionSource,ResultLossSource,
#                  EffectivenessOfSolution=EOS)

###################################################
EOSDamage<-EffectivenessOfSolution(DataLossSource =DataDamage,
                                  DataSolutionSource =DataSolutionSource,
                                  ResultLossSource = NULL)


EOSDamage

# Put: y, n and y
#ReductionDamage(ResultSolutionSource,LossSource=DataDamage,
#                EffectivenessOfSolution=EOSDamage)

}
\author{
Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)
}
