% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qs2all.R
\name{qs2all}
\alias{qs2all}
\title{IDSA of all combinations}
\usage{
qs2all(y, x, xh, location, method = "fuzzyAND")
}
\arguments{
\item{y}{A numeric vector of a response variable}

\item{x}{A numeric vector of a explanatory variable}

\item{xh}{A character variable of an explanatory variable}

\item{location}{A matrix of spatial locations}

\item{method}{A character of overlay methods}
}
\value{
A data frame of all possible power of interactive
determinants (PID) values from IDSA models.
}
\description{
IDSA of all combinations
}
\examples{
library(GD)
x <- sim[,4:6]
x.disc <- apply(x, 2, FUN = function(u) disc(u, 4, "quantile"))
xh <- do.call(cbind, lapply(1:ncol(x), function(u)
  data.frame(cut(x[, u], x.disc[[u]]$itv, include.lowest = TRUE))))
names(xh) <- names(x)
qidsa.all <- qs2all(y = sim$y, x = x, xh = xh,
                    location = sim[, c("lo","la")])

}
