% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6-UserBayesFunctions.R
\name{plot.bayes}
\alias{plot.bayes}
\title{Plotting \code{bayes} Objects}
\usage{
\method{plot}{bayes}(x, iter = NULL, sensitivity = TRUE,
  calculate_criterion = FALSE, sens.bayes.control = list(),
  crt.bayes.control = list(), silent = FALSE, plot_3d = c("lattice",
  "rgl"), evolution = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{bayes}.}

\item{iter}{Iteration number. if \code{NULL}, will be set to last iteration.}

\item{sensitivity}{Logical. If \code{TRUE}, the general equivalence theorem is used to check the optimality if the best design in iteration number \code{iter} and the sensitivity plot will be plotted.}

\item{calculate_criterion}{Re-calculate the criterion value? It only assumes a continuous parameter space for the minimax and standardized maximin designs.  Defaults to \code{FALSE}. See 'Details'.}

\item{sens.bayes.control}{Control parameters to verify general equivalence theorem. For details, see \code{\link{sens.bayes.control}}.}

\item{crt.bayes.control}{Control parameters to approximate the integration in the Bayesian criterion at a given design.
For details, see \code{\link{crt.bayes.control}}.}

\item{silent}{Do not print anything? Defaults to \code{FALSE}.}

\item{plot_3d}{Which package should be used to plot the sensitivity function for two-dimensional design space. Defaults to \code{plot_3d = "lattice"}.
Only applicable when \code{sensitivity = TRUE}.}

\item{evolution}{Plot Evolution? Defaults to \code{FALSE}.}

\item{...}{Argument with no further use.}
}
\description{
This function plots the evolution of the algorithm till iteration number \code{iter} iteration and re-checks the general equivalence theorem by plotting the sensitivity function and calculating the ELB.
}
\details{
The criterion value can also be re-calculated for the output designs using new set of tuning parameters in the function \code{\link{crt.bayes.control}}.
 This is useful for  Bayesian optimal designs to assess the robustness of the
 criterion value with respect to different values of the tuning parameters.
 To put it simple, for these designs, the user can re-calculate the
 criterion value (approximate the integration given an output design in a Bayesian problem) with different values for  \code{maxEval} and \code{tol} in \code{\link{crt.bayes.control}}
 to be sure that the function \code{hcubature} approximates the integrals to an acceptable accuracy using the default values
 (or a new user-given values, in case it has been reset) of \code{maxEval} and \code{tol}.
}
\seealso{
\code{\link{bayes}}, \code{\link{bayescomp}}
}
